/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.ais.UpdateTransactionParametersRequest;
import de.adorsys.psd2.consent.api.service.AccountService;
import de.adorsys.psd2.consent.domain.account.AisConsentTransaction;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.repository.AisConsentTransactionRepository;
import de.adorsys.psd2.consent.repository.ConsentJpaRepository;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccountServiceInternal
implements AccountService {
    private static final Logger log = LoggerFactory.getLogger(AccountServiceInternal.class);
    private final AisConsentTransactionRepository aisConsentTransactionRepository;
    private final ConsentJpaRepository consentJpaRepository;

    @Transactional
    public boolean saveTransactionParameters(String consentId, String resourceId, UpdateTransactionParametersRequest transactionParameters) {
        Optional<ConsentEntity> optionalConsent = this.consentJpaRepository.findByExternalId(consentId);
        if (optionalConsent.isPresent()) {
            AisConsentTransaction aisConsentTransaction = new AisConsentTransaction();
            aisConsentTransaction.setConsentId(optionalConsent.get());
            aisConsentTransaction.setResourceId(resourceId);
            aisConsentTransaction.setNumberOfTransactions(transactionParameters.getNumberOfTransactions());
            aisConsentTransaction.setTotalPages(transactionParameters.getTotalPages());
            aisConsentTransaction.setBookingStatus(transactionParameters.getBookingStatus());
            this.aisConsentTransactionRepository.save(aisConsentTransaction);
            return true;
        }
        log.info("Consent ID: [{}]. Save number of transactions failed, because consent not found", (Object)consentId);
        return false;
    }

    @ConstructorProperties(value={"aisConsentTransactionRepository", "consentJpaRepository"})
    public AccountServiceInternal(AisConsentTransactionRepository aisConsentTransactionRepository, ConsentJpaRepository consentJpaRepository) {
        this.aisConsentTransactionRepository = aisConsentTransactionRepository;
        this.consentJpaRepository = consentJpaRepository;
    }
}

