/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.psu;

import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.repository.ConsentJpaRepository;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.migration.AisConsentLazyMigrationService;
import de.adorsys.psd2.consent.service.psu.CmsPsuService;
import de.adorsys.psd2.consent.service.psu.util.PsuDataUpdater;
import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
class CmsPsuConsentServiceInternal {
    private static final Logger log = LoggerFactory.getLogger(CmsPsuConsentServiceInternal.class);
    private final PsuDataMapper psuDataMapper;
    private final ConsentJpaRepository consentJpaRepository;
    private final CmsPsuService cmsPsuService;
    private final AisConsentLazyMigrationService aisConsentLazyMigrationService;
    private final PsuDataUpdater psuDataUpdater;

    boolean updatePsuData(AuthorisationEntity authorisation, PsuIdData psuIdData, ConsentType consentType) {
        PsuData newPsuData = this.psuDataMapper.mapToPsuData(psuIdData, authorisation.getInstanceId());
        if (newPsuData == null || StringUtils.isBlank((CharSequence)newPsuData.getPsuId())) {
            log.info("Authorisation ID : [{}]. Update PSU data in consent failed in updatePsuData method, because newPsuData or psuId in newPsuData is empty or null.", (Object)authorisation.getExternalId());
            return false;
        }
        Optional<PsuData> optionalPsuData = Optional.ofNullable(authorisation.getPsuData());
        if (optionalPsuData.isPresent()) {
            newPsuData = this.psuDataUpdater.updatePsuDataEntity(optionalPsuData.get(), newPsuData);
        } else {
            List<PsuData> psuDataList;
            Optional<PsuData> psuDataOptional;
            log.info("Authorisation ID [{}]. No PSU data available in the authorisation.", (Object)authorisation.getExternalId());
            Optional<ConsentEntity> consentOptional = this.consentJpaRepository.findByExternalId(authorisation.getParentExternalId());
            if (consentOptional.isEmpty()) {
                log.info("Authorisation ID [{}]. Update PSU data in consent failed, couldn't find consent by the parent ID in the authorisation.", (Object)authorisation.getExternalId());
                return false;
            }
            ConsentEntity consentEntity = consentOptional.get();
            if (consentType == ConsentType.AIS) {
                consentEntity = this.aisConsentLazyMigrationService.migrateIfNeeded(consentEntity);
            }
            if ((psuDataOptional = this.cmsPsuService.definePsuDataForAuthorisation(newPsuData, psuDataList = consentEntity.getPsuDataList())).isPresent()) {
                newPsuData = psuDataOptional.get();
                consentEntity.setPsuDataList(this.cmsPsuService.enrichPsuData(newPsuData, psuDataList));
            }
        }
        authorisation.setPsuData(newPsuData);
        return true;
    }

    @ConstructorProperties(value={"psuDataMapper", "consentJpaRepository", "cmsPsuService", "aisConsentLazyMigrationService", "psuDataUpdater"})
    public CmsPsuConsentServiceInternal(PsuDataMapper psuDataMapper, ConsentJpaRepository consentJpaRepository, CmsPsuService cmsPsuService, AisConsentLazyMigrationService aisConsentLazyMigrationService, PsuDataUpdater psuDataUpdater) {
        this.psuDataMapper = psuDataMapper;
        this.consentJpaRepository = consentJpaRepository;
        this.cmsPsuService = cmsPsuService;
        this.aisConsentLazyMigrationService = aisConsentLazyMigrationService;
        this.psuDataUpdater = psuDataUpdater;
    }
}

