/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.psu;

import de.adorsys.psd2.consent.api.piis.v2.CmsConfirmationOfFundsConsent;
import de.adorsys.psd2.consent.api.piis.v2.CmsConfirmationOfFundsResponse;
import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.psu.api.CmsPsuConfirmationOfFundsAuthorisation;
import de.adorsys.psd2.consent.psu.api.CmsPsuConfirmationOfFundsService;
import de.adorsys.psd2.consent.repository.ConsentJpaRepository;
import de.adorsys.psd2.consent.repository.specification.ConfirmationOfFundsConsentSpecification;
import de.adorsys.psd2.consent.service.authorisation.CmsConsentAuthorisationServiceInternal;
import de.adorsys.psd2.consent.service.mapper.CmsConfirmationOfFundsMapper;
import de.adorsys.psd2.consent.service.mapper.CmsPsuAuthorisationMapper;
import de.adorsys.psd2.consent.service.psu.CmsPsuConsentServiceInternal;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import de.adorsys.psd2.xs2a.core.exception.AuthorisationIsExpiredException;
import de.adorsys.psd2.xs2a.core.exception.RedirectUrlIsExpiredException;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.AuthenticationDataHolder;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CmsPsuConfirmationOfFundsServiceInternal
implements CmsPsuConfirmationOfFundsService {
    private static final Logger log = LoggerFactory.getLogger(CmsPsuConfirmationOfFundsServiceInternal.class);
    private final ConsentJpaRepository consentJpaRepository;
    private final CmsConsentAuthorisationServiceInternal consentAuthorisationService;
    private final ConfirmationOfFundsConsentSpecification confirmationOfFundsConsentSpecification;
    private final CmsConfirmationOfFundsMapper consentMapper;
    private final CmsPsuConsentServiceInternal cmsPsuConsentServiceInternal;
    private final CmsPsuAuthorisationMapper cmsPsuAuthorisationMapper;

    @Transactional
    public boolean updateAuthorisationStatus(@NotNull PsuIdData psuIdData, @NotNull String consentId, @NotNull String authorisationId, @NotNull ScaStatus status, @NotNull String instanceId, AuthenticationDataHolder authenticationDataHolder) throws AuthorisationIsExpiredException {
        Optional<ConsentEntity> actualConsent = this.getActualConsent(consentId, instanceId);
        if (actualConsent.isEmpty()) {
            log.info("Consent ID: [{}], Instance ID: [{}]. Update of authorisation status failed, because consent either has finalised status or not found", (Object)consentId, (Object)instanceId);
            return false;
        }
        return this.consentAuthorisationService.getAuthorisationByAuthorisationId(authorisationId, instanceId).map(authorisation -> this.consentAuthorisationService.updateScaStatusAndAuthenticationData(status, (AuthorisationEntity)authorisation, authenticationDataHolder)).orElseGet(() -> {
            log.info("Authorisation ID [{}], Instance ID: [{}]. Update authorisation status failed, because authorisation not found", (Object)authorisationId, (Object)instanceId);
            return false;
        });
    }

    @Transactional
    public boolean updatePsuDataInConsent(@NotNull PsuIdData psuIdData, @NotNull String authorisationId, @NotNull String instanceId) throws AuthorisationIsExpiredException {
        return this.consentAuthorisationService.getAuthorisationByAuthorisationId(authorisationId, instanceId).map(auth -> this.cmsPsuConsentServiceInternal.updatePsuData((AuthorisationEntity)auth, psuIdData, ConsentType.PIIS_ASPSP)).orElseGet(() -> {
            log.info("Authorisation ID [{}], Instance ID: [{}]. Update PSU  in consent failed, because authorisation not found", (Object)authorisationId, (Object)instanceId);
            return false;
        });
    }

    @Transactional
    @NotNull
    public Optional<CmsConfirmationOfFundsConsent> getConsent(@NotNull PsuIdData psuIdData, @NotNull String consentId, @NotNull String instanceId) {
        return this.consentJpaRepository.findOne(this.confirmationOfFundsConsentSpecification.byConsentIdAndInstanceId(consentId, instanceId)).map(this::mapToCmsConsentWithAuthorisations);
    }

    @Transactional
    public Optional<CmsConfirmationOfFundsResponse> checkRedirectAndGetConsent(String redirectId, String instanceId) throws RedirectUrlIsExpiredException {
        Optional<AuthorisationEntity> optionalAuthorisation = this.consentAuthorisationService.getAuthorisationByRedirectId(redirectId, instanceId);
        if (optionalAuthorisation.isPresent()) {
            AuthorisationEntity authorisation = optionalAuthorisation.get();
            return this.createCmsConsentResponseFromAuthorisation(authorisation, redirectId);
        }
        log.info("Authorisation ID [{}], Instance ID: [{}]. Check redirect URL and get consent failed, because authorisation not found or has finalised status", (Object)redirectId, (Object)instanceId);
        return Optional.empty();
    }

    @NotNull
    public Optional<CmsPsuConfirmationOfFundsAuthorisation> getAuthorisationByAuthorisationId(@NotNull String authorisationId, @NotNull String instanceId) throws AuthorisationIsExpiredException {
        Optional<CmsPsuConfirmationOfFundsAuthorisation> cmsPsuConfirmationOfFundsAuthorisation = this.consentAuthorisationService.getAuthorisationByAuthorisationId(authorisationId, instanceId).map(this.cmsPsuAuthorisationMapper::mapToCmsPsuConfirmationOfFundsAuthorisation);
        if (cmsPsuConfirmationOfFundsAuthorisation.isEmpty()) {
            log.info("Authorisation ID [{}], Instance ID: [{}]. Get authorisation failed, because authorisation not found", (Object)authorisationId, (Object)instanceId);
        }
        return cmsPsuConfirmationOfFundsAuthorisation;
    }

    @Transactional
    public boolean updateConsentStatus(@NotNull String consentId, @NotNull ConsentStatus status, @NotNull String instanceId) {
        Optional<ConsentEntity> consentEntityOptional = this.getActualConsent(consentId, instanceId);
        if (consentEntityOptional.isEmpty()) {
            log.info("Consent ID: [{}], Instance ID: [{}]. Update of consent status failed, because consent either has finalised status or not found", (Object)consentId, (Object)instanceId);
            return false;
        }
        ConsentEntity consentEntity = consentEntityOptional.get();
        consentEntity.setConsentStatus(status);
        return true;
    }

    private Optional<ConsentEntity> getActualConsent(String consentId, String instanceId) {
        return this.consentJpaRepository.findOne(this.confirmationOfFundsConsentSpecification.byConsentIdAndInstanceId(consentId, instanceId)).filter(c -> !c.getConsentStatus().isFinalisedStatus());
    }

    private Optional<CmsConfirmationOfFundsResponse> createCmsConsentResponseFromAuthorisation(AuthorisationEntity authorisation, String redirectId) {
        Optional<ConsentEntity> consentOptional = this.consentJpaRepository.findByExternalId(authorisation.getParentExternalId());
        if (consentOptional.isEmpty()) {
            log.info("Authorisation ID [{}]. Check redirect URL and get consent failed in createCmsConsentResponseFromAuthorisation method, because PIIS consent is null", (Object)redirectId);
            return Optional.empty();
        }
        ConsentEntity consent = consentOptional.get();
        CmsConfirmationOfFundsConsent cmsConfirmationOfFundsConsent = this.mapToCmsConsentWithAuthorisations(consent);
        return Optional.of(new CmsConfirmationOfFundsResponse(cmsConfirmationOfFundsConsent, redirectId, authorisation.getTppOkRedirectUri(), authorisation.getTppNokRedirectUri()));
    }

    private CmsConfirmationOfFundsConsent mapToCmsConsentWithAuthorisations(ConsentEntity consentEntity) {
        List<AuthorisationEntity> authorisations = this.consentAuthorisationService.getAuthorisationsByParentExternalId(consentEntity.getExternalId());
        return this.consentMapper.mapToCmsConfirmationOfFundsConsent(consentEntity, authorisations);
    }

    @ConstructorProperties(value={"consentJpaRepository", "consentAuthorisationService", "confirmationOfFundsConsentSpecification", "consentMapper", "cmsPsuConsentServiceInternal", "cmsPsuAuthorisationMapper"})
    public CmsPsuConfirmationOfFundsServiceInternal(ConsentJpaRepository consentJpaRepository, CmsConsentAuthorisationServiceInternal consentAuthorisationService, ConfirmationOfFundsConsentSpecification confirmationOfFundsConsentSpecification, CmsConfirmationOfFundsMapper consentMapper, CmsPsuConsentServiceInternal cmsPsuConsentServiceInternal, CmsPsuAuthorisationMapper cmsPsuAuthorisationMapper) {
        this.consentJpaRepository = consentJpaRepository;
        this.consentAuthorisationService = consentAuthorisationService;
        this.confirmationOfFundsConsentSpecification = confirmationOfFundsConsentSpecification;
        this.consentMapper = consentMapper;
        this.cmsPsuConsentServiceInternal = cmsPsuConsentServiceInternal;
        this.cmsPsuAuthorisationMapper = cmsPsuAuthorisationMapper;
    }
}

