/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.aspsp;

import de.adorsys.psd2.consent.api.ais.CmsAisAccountConsent;
import de.adorsys.psd2.consent.aspsp.api.PageData;
import de.adorsys.psd2.consent.aspsp.api.ais.CmsAspspAisExportService;
import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.repository.AuthorisationRepository;
import de.adorsys.psd2.consent.repository.ConsentJpaRepository;
import de.adorsys.psd2.consent.repository.specification.AisConsentSpecification;
import de.adorsys.psd2.consent.service.mapper.AisConsentMapper;
import de.adorsys.psd2.consent.service.migration.AisConsentLazyMigrationService;
import de.adorsys.psd2.consent.service.psu.util.PageRequestBuilder;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import de.adorsys.psd2.xs2a.core.pagination.data.PageRequestParameters;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CmsAspspAisExportServiceInternal
implements CmsAspspAisExportService {
    private static final Logger log = LoggerFactory.getLogger(CmsAspspAisExportServiceInternal.class);
    private final AisConsentSpecification aisConsentSpecification;
    private final ConsentJpaRepository consentJpaRepository;
    private final AisConsentMapper aisConsentMapper;
    private final AuthorisationRepository authorisationRepository;
    private final AisConsentLazyMigrationService aisConsentLazyMigrationService;
    private final PageRequestBuilder pageRequestBuilder;

    @Transactional
    public PageData<Collection<CmsAisAccountConsent>> exportConsentsByTpp(String tppAuthorisationNumber, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable PsuIdData psuIdData, @NotNull String instanceId, @Nullable PageRequestParameters pageRequestParameters, @Nullable String additionalTppInfo) {
        if (StringUtils.isBlank((CharSequence)tppAuthorisationNumber) || StringUtils.isBlank((CharSequence)instanceId)) {
            log.info("TPP ID: [{}], InstanceId: [{}]. Export Consents by TPP: Some of these two values are empty", (Object)tppAuthorisationNumber, (Object)instanceId);
            return new PageData(Collections.emptyList(), 0L, (long)Optional.ofNullable(pageRequestParameters).map(PageRequestParameters::getItemsPerPage).orElse(0).intValue(), 0L);
        }
        return this.mapToPageData((Page<ConsentEntity>)this.consentJpaRepository.findAll(this.aisConsentSpecification.byTppIdAndCreationPeriodAndPsuIdDataAndInstanceId(tppAuthorisationNumber, createDateFrom, createDateTo, psuIdData, instanceId, additionalTppInfo), this.pageRequestBuilder.getPageable(pageRequestParameters)));
    }

    @Transactional
    public PageData<Collection<CmsAisAccountConsent>> exportConsentsByPsuAndAdditionalTppInfo(PsuIdData psuIdData, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @NotNull String instanceId, Integer pageIndex, Integer itemsPerPage, @Nullable String additionalTppInfo) {
        if (psuIdData == null || psuIdData.isEmpty() || StringUtils.isBlank((CharSequence)instanceId)) {
            log.info("InstanceId: [{}]. Export consents by Psu failed, psuIdData or instanceId is empty or null.", (Object)instanceId);
            return new PageData(Collections.emptyList(), 0L, (long)itemsPerPage.intValue(), 0L);
        }
        return this.mapToPageData((Page<ConsentEntity>)this.consentJpaRepository.findAll(this.aisConsentSpecification.byPsuIdDataAndCreationPeriodAndInstanceIdAndAdditionalTppInfo(psuIdData, createDateFrom, createDateTo, instanceId, additionalTppInfo), this.pageRequestBuilder.getPageable(pageIndex, itemsPerPage)));
    }

    @Transactional
    public PageData<Collection<CmsAisAccountConsent>> exportConsentsByAccountIdAndAdditionalTppInfo(@NotNull String aspspAccountId, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @NotNull String instanceId, Integer pageIndex, Integer itemsPerPage, @Nullable String additionalTppInfo) {
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            log.info("InstanceId: [{}], aspspAccountId: [{}]. Export consents by accountId failed, instanceId is empty or null.", (Object)instanceId, (Object)aspspAccountId);
            return new PageData(Collections.emptyList(), 0L, (long)itemsPerPage.intValue(), 0L);
        }
        ZoneOffset currentOffset = OffsetDateTime.now().getOffset();
        OffsetDateTime startOffsetDateTime = Optional.ofNullable(createDateFrom).map(odt -> OffsetDateTime.of(odt, LocalTime.MIN, currentOffset)).orElse(OffsetDateTime.now().minusYears(10L));
        OffsetDateTime endOffsetDateTime = Optional.ofNullable(createDateTo).map(odt -> OffsetDateTime.of(odt, LocalTime.MAX, currentOffset)).orElse(OffsetDateTime.now().plusYears(10L));
        Pageable pageable = this.pageRequestBuilder.getPageable(pageIndex, itemsPerPage);
        Page<ConsentEntity> consentEntityPage = additionalTppInfo == null ? this.consentJpaRepository.findAllWithPagination(Collections.singleton(ConsentType.AIS.getName()), aspspAccountId, startOffsetDateTime, endOffsetDateTime, instanceId, pageable) : this.consentJpaRepository.findAllWithPaginationAndTppInfo(Collections.singleton(ConsentType.AIS.getName()), aspspAccountId, startOffsetDateTime, endOffsetDateTime, instanceId, pageable, additionalTppInfo);
        return this.mapToPageData(consentEntityPage);
    }

    private PageData<Collection<CmsAisAccountConsent>> mapToPageData(Page<ConsentEntity> entities) {
        return new PageData((Object)entities.stream().map(this.aisConsentLazyMigrationService::migrateIfNeeded).map(this::mapToCmsAisAccountConsentWithAuthorisations).collect(Collectors.toList()), (long)entities.getPageable().getPageNumber(), (long)entities.getPageable().getPageSize(), entities.getTotalElements());
    }

    private CmsAisAccountConsent mapToCmsAisAccountConsentWithAuthorisations(ConsentEntity aisConsentEntity) {
        List<AuthorisationEntity> authorisations = this.authorisationRepository.findAllByParentExternalIdAndType(aisConsentEntity.getExternalId(), AuthorisationType.CONSENT);
        return this.aisConsentMapper.mapToCmsAisAccountConsent(aisConsentEntity, authorisations);
    }

    @ConstructorProperties(value={"aisConsentSpecification", "consentJpaRepository", "aisConsentMapper", "authorisationRepository", "aisConsentLazyMigrationService", "pageRequestBuilder"})
    public CmsAspspAisExportServiceInternal(AisConsentSpecification aisConsentSpecification, ConsentJpaRepository consentJpaRepository, AisConsentMapper aisConsentMapper, AuthorisationRepository authorisationRepository, AisConsentLazyMigrationService aisConsentLazyMigrationService, PageRequestBuilder pageRequestBuilder) {
        this.aisConsentSpecification = aisConsentSpecification;
        this.consentJpaRepository = consentJpaRepository;
        this.aisConsentMapper = aisConsentMapper;
        this.authorisationRepository = authorisationRepository;
        this.aisConsentLazyMigrationService = aisConsentLazyMigrationService;
        this.pageRequestBuilder = pageRequestBuilder;
    }
}

