/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.security;

import de.adorsys.psd2.consent.service.security.DecryptedData;
import de.adorsys.psd2.consent.service.security.EncryptedData;
import de.adorsys.psd2.consent.service.security.provider.CryptoProvider;
import de.adorsys.psd2.consent.service.security.provider.CryptoProviderFactory;
import java.beans.ConstructorProperties;
import java.util.Base64;
import java.util.Optional;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class SecurityDataService {
    private static final Logger log = LoggerFactory.getLogger(SecurityDataService.class);
    private static final String SEPARATOR = "_=_";
    private String serverKey;
    private final CryptoProviderFactory cryptoProviderFactory;

    @Autowired
    public SecurityDataService(Environment environment, CryptoProviderFactory cryptoProviderFactory) {
        this.cryptoProviderFactory = cryptoProviderFactory;
        this.serverKey = environment.getProperty("server_key");
        if (StringUtils.isBlank((CharSequence)this.serverKey)) {
            log.error("The 'server_key' must be specified at CMS start");
            throw new IllegalArgumentException("CMS_SERVER_KEY_MISSING");
        }
    }

    public Optional<String> encryptId(String originalId) {
        String consentKey = RandomStringUtils.random((int)16, (boolean)true, (boolean)true);
        String compositeConsentId = this.concatWithSeparator(originalId, consentKey);
        byte[] bytesCompositeConsentId = compositeConsentId.getBytes();
        Optional<String> encryptedId = this.identifierCP().encryptData(bytesCompositeConsentId, this.serverKey).map(EncryptedData::getData).map(raw -> Base64.getUrlEncoder().encodeToString((byte[])raw)).map(this::addVersionToEncryptedId);
        if (!encryptedId.isPresent()) {
            log.warn("Couldn't encrypt ID: {}", (Object)originalId);
        }
        return encryptedId;
    }

    public Optional<String> decryptId(String encryptedId) {
        if (!encryptedId.contains(SEPARATOR)) {
            log.warn("Couldn't decrypt ID: {}", (Object)encryptedId);
            return Optional.empty();
        }
        Optional<String> decryptedId = this.decryptCompositeId(encryptedId).map(cmst -> cmst.split(SEPARATOR)[0]);
        if (!decryptedId.isPresent()) {
            log.warn("Couldn't decrypt ID: {}", (Object)encryptedId);
        }
        return decryptedId;
    }

    public Optional<EncryptedData> encryptConsentData(String encryptedId, byte[] aspspConsentData) {
        return this.getConsentKeyByEncryptedId(encryptedId).flatMap(consentKey -> this.consentDataCP().encryptData(aspspConsentData, (String)consentKey));
    }

    public Optional<DecryptedData> decryptConsentData(String encryptedId, byte[] aspspConsentData) {
        return this.getConsentKeyByEncryptedId(encryptedId).flatMap(consentKey -> this.consentDataCP().decryptData(aspspConsentData, (String)consentKey));
    }

    public boolean isConsentIdEncrypted(String consentId) {
        return consentId.contains(SEPARATOR);
    }

    private Optional<String> decryptCompositeId(String encryptedId) {
        String encryptedCompositeId = encryptedId.substring(0, encryptedId.indexOf(SEPARATOR));
        byte[] bytesCompositeId = this.decode64(encryptedCompositeId, true);
        if (bytesCompositeId == null) {
            return Optional.empty();
        }
        String algorithmVersion = encryptedId.substring(encryptedId.indexOf(SEPARATOR) + SEPARATOR.length());
        Optional<CryptoProvider> provider = this.cryptoProviderFactory.getCryptoProviderByAlgorithmVersion(algorithmVersion);
        return provider.flatMap(prd -> prd.decryptData(bytesCompositeId, this.serverKey)).map(ed -> new String(ed.getData())).filter(StringUtils::isAsciiPrintable);
    }

    private Optional<String> getConsentKeyByEncryptedId(String encryptedId) {
        return this.decryptCompositeId(encryptedId).map(comst -> comst.split(SEPARATOR)[1]);
    }

    private byte[] decode64(String raw, boolean urlsafe) {
        try {
            return urlsafe ? Base64.getUrlDecoder().decode(raw) : Base64.getDecoder().decode(raw);
        }
        catch (IllegalArgumentException ex) {
            log.error("Input id has wrong format: {}", (Object)raw);
            return null;
        }
    }

    private String addVersionToEncryptedId(String encryptedId) {
        String algorithmVersion = this.identifierCP().getAlgorithmVersion().getExternalId();
        return this.concatWithSeparator(encryptedId, algorithmVersion);
    }

    private CryptoProvider consentDataCP() {
        return this.cryptoProviderFactory.actualConsentDataCryptoProvider();
    }

    private CryptoProvider identifierCP() {
        return this.cryptoProviderFactory.actualIdentifierCryptoProvider();
    }

    private String concatWithSeparator(String leftPart, String rightPart) {
        StringBuilder sb = new StringBuilder();
        sb.append(leftPart);
        sb.append(SEPARATOR);
        sb.append(rightPart);
        return sb.toString();
    }

    @ConstructorProperties(value={"cryptoProviderFactory"})
    public SecurityDataService(CryptoProviderFactory cryptoProviderFactory) {
        this.cryptoProviderFactory = cryptoProviderFactory;
    }
}

