/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.psu;

import de.adorsys.psd2.consent.api.pis.CmsPayment;
import de.adorsys.psd2.consent.api.pis.CmsPaymentResponse;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentService;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.TppInfoEntity;
import de.adorsys.psd2.consent.domain.payment.PisAuthorization;
import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.domain.payment.PisPaymentData;
import de.adorsys.psd2.consent.psu.api.CmsPsuPisService;
import de.adorsys.psd2.consent.repository.PisAuthorizationRepository;
import de.adorsys.psd2.consent.repository.PisPaymentDataRepository;
import de.adorsys.psd2.consent.repository.PsuDataRepository;
import de.adorsys.psd2.consent.repository.specification.PisAuthorisationSpecification;
import de.adorsys.psd2.consent.repository.specification.PisPaymentDataSpecification;
import de.adorsys.psd2.consent.service.CommonPaymentDataService;
import de.adorsys.psd2.consent.service.mapper.CmsPsuPisMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CmsPsuPisServiceInternal
implements CmsPsuPisService {
    private static final Logger log = LoggerFactory.getLogger(CmsPsuPisServiceInternal.class);
    private final PisPaymentDataRepository pisPaymentDataRepository;
    private final PisAuthorizationRepository pisAuthorizationRepository;
    private final CmsPsuPisMapper cmsPsuPisMapper;
    private final PisCommonPaymentService pisCommonPaymentService;
    private final CommonPaymentDataService commonPaymentDataService;
    private final PsuDataMapper psuDataMapper;
    private final PsuDataRepository psuDataRepository;
    private final PisAuthorisationSpecification pisAuthorisationSpecification;
    private final PisPaymentDataSpecification pisPaymentDataSpecification;

    @Transactional
    public boolean updatePsuInPayment(@NotNull PsuIdData psuIdData, @NotNull String redirectId, @NotNull String instanceId) {
        return Optional.ofNullable(this.pisAuthorizationRepository.findOne(this.pisAuthorisationSpecification.byExternalIdAndInstanceId(redirectId, instanceId))).map(PisAuthorization::getPsuData).map(psuData -> this.updatePsuData((PsuData)psuData, psuIdData)).orElse(false);
    }

    @NotNull
    public Optional<CmsPayment> getPayment(@NotNull PsuIdData psuIdData, @NotNull String paymentId, @NotNull String instanceId) {
        if (this.isPsuDataEquals(paymentId, psuIdData)) {
            List list = this.pisPaymentDataRepository.findAll(this.pisPaymentDataSpecification.byPaymentIdAndInstanceId(paymentId, instanceId));
            if (!list.isEmpty()) {
                return Optional.of(this.cmsPsuPisMapper.mapToCmsPayment(list));
            }
            return this.commonPaymentDataService.getPisCommonPaymentData(paymentId, instanceId).map(this.cmsPsuPisMapper::mapToCmsPayment);
        }
        return Optional.empty();
    }

    @Transactional
    @NotNull
    public Optional<CmsPaymentResponse> checkRedirectAndGetPayment(@NotNull PsuIdData psuIdData, @NotNull String redirectId, @NotNull String instanceId) {
        Optional<PisAuthorization> optionalAuthorisation = Optional.ofNullable(this.pisAuthorizationRepository.findOne(this.pisAuthorisationSpecification.byExternalIdAndInstanceId(redirectId, instanceId))).filter(a -> this.isAuthorisationValidForPsuAndStatus(psuIdData, (PisAuthorization)a));
        if (optionalAuthorisation.isPresent()) {
            PisAuthorization authorisation = optionalAuthorisation.get();
            if (authorisation.isNotExpired()) {
                return Optional.of(this.buildCmsPaymentResponse(authorisation));
            }
            this.changeAuthorisationStatusToFailed(authorisation);
            String tppNokRedirectUri = authorisation.getPaymentData().getTppInfo().getNokRedirectUri();
            return Optional.of(new CmsPaymentResponse(tppNokRedirectUri));
        }
        return Optional.empty();
    }

    @Transactional
    @NotNull
    public Optional<CmsPaymentResponse> checkRedirectAndGetPaymentForCancellation(@NotNull PsuIdData psuIdData, @NotNull String redirectId, @NotNull String instanceId) {
        Optional<PisAuthorization> optionalAuthorisation = Optional.ofNullable(this.pisAuthorizationRepository.findOne(this.pisAuthorisationSpecification.byExternalIdAndInstanceId(redirectId, instanceId))).filter(a -> this.isAuthorisationValidForPsuAndStatus(psuIdData, (PisAuthorization)a));
        if (!optionalAuthorisation.isPresent()) {
            return Optional.empty();
        }
        PisAuthorization authorisation = optionalAuthorisation.get();
        if (authorisation.isExpired()) {
            this.changeAuthorisationStatusToFailed(authorisation);
            return Optional.of(new CmsPaymentResponse());
        }
        return Optional.of(this.buildCmsPaymentResponseForCancellation(authorisation));
    }

    @Transactional
    public boolean updateAuthorisationStatus(@NotNull PsuIdData psuIdData, @NotNull String paymentId, @NotNull String authorisationId, @NotNull ScaStatus status, @NotNull String instanceId) {
        Optional<Object> pisAuthorisation = Optional.ofNullable(this.pisAuthorizationRepository.findOne(this.pisAuthorisationSpecification.byExternalIdAndInstanceId(authorisationId, instanceId)));
        boolean isValid = pisAuthorisation.map(auth -> auth.getPaymentData().getPaymentId()).map(id -> this.validateGivenData((String)id, paymentId, psuIdData)).orElse(false);
        return isValid && this.updateAuthorisationStatusAndSaveAuthorisation((PisAuthorization)pisAuthorisation.get(), status);
    }

    @Transactional
    public boolean updatePaymentStatus(@NotNull String paymentId, @NotNull TransactionStatus status, @NotNull String instanceId) {
        List list = this.pisPaymentDataRepository.findAll(this.pisPaymentDataSpecification.byPaymentIdAndInstanceId(paymentId, instanceId));
        if (!list.isEmpty()) {
            return this.updateStatusInPaymentDataList(list, status);
        }
        Optional<PisCommonPaymentData> paymentDataOptional = this.commonPaymentDataService.getPisCommonPaymentData(paymentId, instanceId);
        return paymentDataOptional.isPresent() && this.commonPaymentDataService.updateStatusInPaymentData(paymentDataOptional.get(), status);
    }

    private boolean updatePsuData(PsuData psuData, PsuIdData psuIdData) {
        PsuData newPsuData = this.psuDataMapper.mapToPsuData(psuIdData);
        if (newPsuData == null || StringUtils.isBlank((CharSequence)newPsuData.getPsuId())) {
            return false;
        }
        newPsuData.setId(psuData.getId());
        this.psuDataRepository.save(newPsuData);
        return true;
    }

    private boolean validateGivenData(String realPaymentId, String givenPaymentId, PsuIdData psuIdData) {
        return Optional.of(givenPaymentId).filter(p -> this.isPsuDataEquals((String)p, psuIdData)).map(id -> StringUtils.equals((CharSequence)realPaymentId, (CharSequence)id)).orElse(false);
    }

    private boolean updateAuthorisationStatusAndSaveAuthorisation(PisAuthorization pisAuthorisation, ScaStatus status) {
        if (pisAuthorisation.getScaStatus().isFinalisedStatus()) {
            return false;
        }
        pisAuthorisation.setScaStatus(status);
        return Optional.ofNullable(this.pisAuthorizationRepository.save(pisAuthorisation)).isPresent();
    }

    private boolean isPsuDataEquals(String paymentId, PsuIdData psuIdData) {
        return this.pisCommonPaymentService.getPsuDataListByPaymentId(paymentId).map(lst -> lst.stream().anyMatch(psu -> psu.contentEquals(psuIdData))).orElse(false);
    }

    private boolean updateStatusInPaymentDataList(List<PisPaymentData> dataList, TransactionStatus givenStatus) {
        for (PisPaymentData pisPaymentData : dataList) {
            if (pisPaymentData.getTransactionStatus().isFinalisedStatus()) {
                return false;
            }
            pisPaymentData.setTransactionStatus(givenStatus);
            this.pisPaymentDataRepository.save(pisPaymentData);
        }
        return true;
    }

    private boolean isAuthorisationValidForPsuAndStatus(PsuIdData givenPsuIdData, PisAuthorization authorization) {
        if (authorization.getScaStatus().isFinalisedStatus()) {
            return false;
        }
        PsuIdData actualPsuIdData = this.psuDataMapper.mapToPsuIdData(authorization.getPsuData());
        return Optional.ofNullable(actualPsuIdData).map(arg_0 -> ((PsuIdData)givenPsuIdData).contentEquals(arg_0)).orElse(false);
    }

    private CmsPaymentResponse buildCmsPaymentResponse(PisAuthorization authorisation) {
        PisCommonPaymentData commonPayment = authorisation.getPaymentData();
        CmsPayment payment = this.cmsPsuPisMapper.mapToCmsPayment(commonPayment.getPayments());
        TppInfoEntity tppInfo = commonPayment.getTppInfo();
        String tppOkRedirectUri = tppInfo.getRedirectUri();
        String tppNokRedirectUri = tppInfo.getNokRedirectUri();
        return new CmsPaymentResponse(payment, authorisation.getExternalId(), tppOkRedirectUri, tppNokRedirectUri);
    }

    private CmsPaymentResponse buildCmsPaymentResponseForCancellation(PisAuthorization authorisation) {
        PisCommonPaymentData commonPayment = authorisation.getPaymentData();
        CmsPayment payment = this.cmsPsuPisMapper.mapToCmsPayment(commonPayment.getPayments());
        return new CmsPaymentResponse(payment, authorisation.getExternalId(), null, null);
    }

    private void changeAuthorisationStatusToFailed(PisAuthorization authorisation) {
        authorisation.setScaStatus(ScaStatus.FAILED);
        this.pisAuthorizationRepository.save(authorisation);
    }

    @ConstructorProperties(value={"pisPaymentDataRepository", "pisAuthorizationRepository", "cmsPsuPisMapper", "pisCommonPaymentService", "commonPaymentDataService", "psuDataMapper", "psuDataRepository", "pisAuthorisationSpecification", "pisPaymentDataSpecification"})
    public CmsPsuPisServiceInternal(PisPaymentDataRepository pisPaymentDataRepository, PisAuthorizationRepository pisAuthorizationRepository, CmsPsuPisMapper cmsPsuPisMapper, PisCommonPaymentService pisCommonPaymentService, CommonPaymentDataService commonPaymentDataService, PsuDataMapper psuDataMapper, PsuDataRepository psuDataRepository, PisAuthorisationSpecification pisAuthorisationSpecification, PisPaymentDataSpecification pisPaymentDataSpecification) {
        this.pisPaymentDataRepository = pisPaymentDataRepository;
        this.pisAuthorizationRepository = pisAuthorizationRepository;
        this.cmsPsuPisMapper = cmsPsuPisMapper;
        this.pisCommonPaymentService = pisCommonPaymentService;
        this.commonPaymentDataService = commonPaymentDataService;
        this.psuDataMapper = psuDataMapper;
        this.psuDataRepository = psuDataRepository;
        this.pisAuthorisationSpecification = pisAuthorisationSpecification;
        this.pisPaymentDataSpecification = pisPaymentDataSpecification;
    }
}

