/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.psu;

import de.adorsys.psd2.consent.api.ais.AisAccountConsent;
import de.adorsys.psd2.consent.api.ais.CmsAisConsentResponse;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.domain.account.AisConsentAuthorization;
import de.adorsys.psd2.consent.psu.api.CmsPsuAisService;
import de.adorsys.psd2.consent.repository.AisConsentAuthorizationRepository;
import de.adorsys.psd2.consent.repository.AisConsentRepository;
import de.adorsys.psd2.consent.repository.PsuDataRepository;
import de.adorsys.psd2.consent.repository.specification.AisConsentAuthorizationSpecification;
import de.adorsys.psd2.consent.repository.specification.AisConsentSpecification;
import de.adorsys.psd2.consent.service.mapper.AisConsentMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CmsPsuAisServiceInternal
implements CmsPsuAisService {
    private final AisConsentRepository aisConsentRepository;
    private final AisConsentMapper consentMapper;
    private final PsuDataRepository psuDataRepository;
    private final PsuDataMapper psuDataMapper;
    private final AisConsentAuthorizationRepository aisConsentAuthorizationRepository;
    private final AisConsentAuthorizationSpecification aisConsentAuthorizationSpecification;
    private final AisConsentSpecification aisConsentSpecification;

    @Transactional
    public boolean updatePsuDataInConsent(@NotNull PsuIdData psuIdData, @NotNull String redirectId, @NotNull String instanceId) {
        return Optional.ofNullable(this.aisConsentAuthorizationRepository.findOne(this.aisConsentAuthorizationSpecification.byExternalIdAndInstanceId(redirectId, instanceId))).map(AisConsentAuthorization::getConsent).map(con -> this.updatePsuData((AisConsent)con, psuIdData)).orElse(false);
    }

    @Transactional
    @NotNull
    public Optional<AisAccountConsent> getConsent(@NotNull PsuIdData psuIdData, @NotNull String consentId, @NotNull String instanceId) {
        return Optional.ofNullable(this.aisConsentRepository.findOne(this.aisConsentSpecification.byConsentIdAndInstanceId(consentId, instanceId))).map(this::checkAndUpdateOnExpiration).map(this.consentMapper::mapToAisAccountConsent);
    }

    @Transactional
    public boolean updateAuthorisationStatus(@NotNull PsuIdData psuIdData, @NotNull String consentId, @NotNull String authorisationId, @NotNull ScaStatus status, @NotNull String instanceId) {
        Optional<AisConsent> actualAisConsent = this.getActualAisConsent(consentId, instanceId);
        if (!actualAisConsent.isPresent()) {
            return false;
        }
        return Optional.ofNullable(this.aisConsentAuthorizationRepository.findOne(this.aisConsentAuthorizationSpecification.byExternalIdAndInstanceId(authorisationId, instanceId))).map(auth -> this.updateScaStatus(status, (AisConsentAuthorization)auth)).orElse(false);
    }

    @Transactional
    public boolean confirmConsent(@NotNull PsuIdData psuIdData, @NotNull String consentId, @NotNull String instanceId) {
        return this.changeConsentStatus(consentId, ConsentStatus.VALID, instanceId);
    }

    @Transactional
    public boolean rejectConsent(@NotNull PsuIdData psuIdData, @NotNull String consentId, @NotNull String instanceId) {
        return this.changeConsentStatus(consentId, ConsentStatus.REJECTED, instanceId);
    }

    @NotNull
    public List<AisAccountConsent> getConsentsForPsu(@NotNull PsuIdData psuIdData, @NotNull String instanceId) {
        return this.aisConsentRepository.findAll(this.aisConsentSpecification.byPsuIdIdAndInstanceId(psuIdData.getPsuId(), instanceId)).stream().map(this.consentMapper::mapToAisAccountConsent).collect(Collectors.toList());
    }

    @Transactional
    public boolean revokeConsent(@NotNull PsuIdData psuIdData, @NotNull String consentId, @NotNull String instanceId) {
        return this.changeConsentStatus(consentId, ConsentStatus.REVOKED_BY_PSU, instanceId);
    }

    @Transactional
    @NotNull
    public Optional<CmsAisConsentResponse> checkRedirectAndGetConsent(@NotNull PsuIdData psuIdData, @NotNull String redirectId, @NotNull String instanceId) {
        Optional<AisConsentAuthorization> optionalAuthorisation = Optional.ofNullable(this.aisConsentAuthorizationRepository.findOne(this.aisConsentAuthorizationSpecification.byExternalIdAndInstanceId(redirectId, instanceId))).filter(a -> this.isConsentAuthorisationValidForPsuAndStatus(psuIdData, (AisConsentAuthorization)a));
        if (optionalAuthorisation.isPresent()) {
            AisConsentAuthorization authorisation = optionalAuthorisation.get();
            if (authorisation.isNotExpired()) {
                return this.createCmsAisConsentResponseFromAisConsent(authorisation.getConsent(), redirectId);
            }
            this.updateAuthorisationOnExpiration(authorisation);
            String tppNokRedirectUri = authorisation.getConsent().getTppInfo().getNokRedirectUri();
            return Optional.of(new CmsAisConsentResponse(tppNokRedirectUri));
        }
        return Optional.empty();
    }

    private boolean isConsentAuthorisationValidForPsuAndStatus(PsuIdData givenPsuIdData, AisConsentAuthorization authorisation) {
        if (authorisation.getScaStatus().isFinalisedStatus()) {
            return false;
        }
        PsuIdData actualPsuIdData = this.psuDataMapper.mapToPsuIdData(authorisation.getPsuData());
        return Optional.ofNullable(actualPsuIdData).map(arg_0 -> ((PsuIdData)givenPsuIdData).contentEquals(arg_0)).orElse(false);
    }

    private boolean changeConsentStatus(String consentId, ConsentStatus status, String instanceId) {
        return Optional.ofNullable(this.aisConsentRepository.findOne(this.aisConsentSpecification.byConsentIdAndInstanceId(consentId, instanceId))).map(con -> this.updateConsentStatus((AisConsent)con, status)).orElse(false);
    }

    private AisConsent checkAndUpdateOnExpiration(AisConsent consent) {
        if (consent != null && consent.isExpiredByDate() && consent.isStatusNotExpired()) {
            consent.setConsentStatus(ConsentStatus.EXPIRED);
            consent.setExpireDate(LocalDate.now());
            consent.setLastActionDate(LocalDate.now());
            this.aisConsentRepository.save(consent);
        }
        return consent;
    }

    private Optional<AisConsent> getActualAisConsent(String consentId, String instanceId) {
        return Optional.ofNullable(this.aisConsentRepository.findOne(this.aisConsentSpecification.byConsentIdAndInstanceId(consentId, instanceId))).filter(c -> !c.getConsentStatus().isFinalisedStatus());
    }

    private boolean updateConsentStatus(AisConsent consent, ConsentStatus status) {
        if (consent.getConsentStatus().isFinalisedStatus()) {
            return false;
        }
        consent.setLastActionDate(LocalDate.now());
        consent.setConsentStatus(status);
        return this.aisConsentRepository.save(consent) != null;
    }

    private boolean updatePsuData(AisConsent consent, PsuIdData psuIdData) {
        PsuData psuData = consent.getPsuData();
        psuData.setPsuId(psuIdData.getPsuId());
        psuData.setPsuIdType(psuIdData.getPsuIdType());
        psuData.setPsuCorporateId(psuIdData.getPsuCorporateId());
        psuData.setPsuCorporateIdType(psuIdData.getPsuCorporateIdType());
        return this.psuDataRepository.save(psuData) != null;
    }

    private boolean updateScaStatus(@NotNull ScaStatus status, AisConsentAuthorization authorization) {
        if (authorization.getScaStatus().isFinalisedStatus()) {
            return false;
        }
        authorization.setScaStatus(status);
        return this.aisConsentAuthorizationRepository.save(authorization) != null;
    }

    private void updateAuthorisationOnExpiration(AisConsentAuthorization authorisation) {
        authorisation.setScaStatus(ScaStatus.FAILED);
        this.aisConsentAuthorizationRepository.save(authorisation);
    }

    private Optional<CmsAisConsentResponse> createCmsAisConsentResponseFromAisConsent(AisConsent aisConsent, String redirectId) {
        if (aisConsent == null) {
            return Optional.empty();
        }
        AisAccountConsent aisAccountConsent = this.consentMapper.mapToAisAccountConsent(aisConsent);
        Optional<TppInfo> tppInfoOptional = Optional.ofNullable(aisAccountConsent).map(AisAccountConsent::getTppInfo);
        if (!tppInfoOptional.isPresent()) {
            return Optional.empty();
        }
        Optional<TppRedirectUri> tppRedirectUriOptional = tppInfoOptional.map(TppInfo::getTppRedirectUri);
        String tppOkRedirectUri = null;
        String tppNokRedirectUri = null;
        if (tppRedirectUriOptional.isPresent()) {
            TppRedirectUri tppRedirectUri = tppRedirectUriOptional.get();
            tppOkRedirectUri = tppRedirectUri.getUri();
            tppNokRedirectUri = tppRedirectUri.getNokUri();
        }
        return Optional.of(new CmsAisConsentResponse(aisAccountConsent, redirectId, tppOkRedirectUri, tppNokRedirectUri));
    }

    @ConstructorProperties(value={"aisConsentRepository", "consentMapper", "psuDataRepository", "psuDataMapper", "aisConsentAuthorizationRepository", "aisConsentAuthorizationSpecification", "aisConsentSpecification"})
    public CmsPsuAisServiceInternal(AisConsentRepository aisConsentRepository, AisConsentMapper consentMapper, PsuDataRepository psuDataRepository, PsuDataMapper psuDataMapper, AisConsentAuthorizationRepository aisConsentAuthorizationRepository, AisConsentAuthorizationSpecification aisConsentAuthorizationSpecification, AisConsentSpecification aisConsentSpecification) {
        this.aisConsentRepository = aisConsentRepository;
        this.consentMapper = consentMapper;
        this.psuDataRepository = psuDataRepository;
        this.psuDataMapper = psuDataMapper;
        this.aisConsentAuthorizationRepository = aisConsentAuthorizationRepository;
        this.aisConsentAuthorizationSpecification = aisConsentAuthorizationSpecification;
        this.aisConsentSpecification = aisConsentSpecification;
    }
}

