/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.domain.TppInfoEntity;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import de.adorsys.psd2.xs2a.core.tpp.TppRole;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class TppInfoMapper {
    public TppInfoEntity mapToTppInfoEntity(TppInfo tppInfo) {
        return Optional.ofNullable(tppInfo).map(tin -> {
            TppInfoEntity pisTppInfo = new TppInfoEntity();
            pisTppInfo.setAuthorisationNumber(tin.getAuthorisationNumber());
            pisTppInfo.setTppName(tin.getTppName());
            pisTppInfo.setTppRoles(new ArrayList<TppRole>(tin.getTppRoles()));
            pisTppInfo.setAuthorityId(tin.getAuthorityId());
            pisTppInfo.setAuthorityName(tin.getAuthorityName());
            pisTppInfo.setCountry(tin.getCountry());
            pisTppInfo.setOrganisation(tin.getOrganisation());
            pisTppInfo.setOrganisationUnit(tin.getOrganisationUnit());
            pisTppInfo.setCity(tin.getCity());
            pisTppInfo.setState(tin.getState());
            TppRedirectUri tppRedirectUri = tin.getTppRedirectUri();
            if (tppRedirectUri != null) {
                pisTppInfo.setRedirectUri(tppRedirectUri.getUri());
                pisTppInfo.setNokRedirectUri(tppRedirectUri.getNokUri());
            }
            return pisTppInfo;
        }).orElse(null);
    }

    TppInfo mapToTppInfo(TppInfoEntity tppInfoEntity) {
        return Optional.ofNullable(tppInfoEntity).map(tpp -> {
            TppInfo tppInfo = new TppInfo();
            tppInfo.setAuthorisationNumber(tpp.getAuthorisationNumber());
            tppInfo.setTppName(tpp.getTppName());
            tppInfo.setTppRoles(new ArrayList<TppRole>(tpp.getTppRoles()));
            tppInfo.setAuthorityId(tpp.getAuthorityId());
            tppInfo.setAuthorityName(tpp.getAuthorityName());
            tppInfo.setCountry(tpp.getCountry());
            tppInfo.setOrganisation(tpp.getOrganisation());
            tppInfo.setOrganisationUnit(tpp.getOrganisationUnit());
            tppInfo.setCity(tpp.getCity());
            tppInfo.setState(tpp.getState());
            if (tpp.getRedirectUri() != null) {
                TppRedirectUri tppRedirectUri = new TppRedirectUri(tpp.getRedirectUri(), tpp.getNokRedirectUri());
                tppInfo.setTppRedirectUri(tppRedirectUri);
            }
            return tppInfo;
        }).orElse(null);
    }
}

