/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.domain.event.EventEntity;
import de.adorsys.psd2.consent.service.JsonConverterService;
import de.adorsys.psd2.xs2a.core.event.Event;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class EventMapper {
    private final JsonConverterService jsonConverterService;

    public List<Event> mapToEventList(@NotNull List<EventEntity> eventEntities) {
        return eventEntities.stream().map(this::mapToEvent).collect(Collectors.toList());
    }

    public EventEntity mapToEventEntity(@NotNull Event event) {
        EventEntity eventEntity = new EventEntity();
        eventEntity.setTimestamp(event.getTimestamp());
        eventEntity.setConsentId(event.getConsentId());
        eventEntity.setPaymentId(event.getPaymentId());
        byte[] payload = this.jsonConverterService.toJsonBytes(event.getPayload()).orElse(null);
        eventEntity.setPayload(payload);
        eventEntity.setEventOrigin(event.getEventOrigin());
        eventEntity.setEventType(event.getEventType());
        return eventEntity;
    }

    private Event mapToEvent(@NotNull EventEntity eventEntity) {
        Object payload = this.jsonConverterService.toObject(eventEntity.getPayload(), Object.class).orElse(null);
        return Event.builder().timestamp(eventEntity.getTimestamp()).consentId(eventEntity.getConsentId()).paymentId(eventEntity.getPaymentId()).payload(payload).eventOrigin(eventEntity.getEventOrigin()).eventType(eventEntity.getEventType()).instanceId(eventEntity.getInstanceId()).build();
    }

    @ConstructorProperties(value={"jsonConverterService"})
    public EventMapper(JsonConverterService jsonConverterService) {
        this.jsonConverterService = jsonConverterService;
    }
}

