/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.mapper;

import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.consent.api.ais.AisAccountAccess;
import de.adorsys.psd2.consent.api.ais.AisAccountConsent;
import de.adorsys.psd2.consent.api.ais.AisConsentAuthorizationResponse;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.domain.account.AisConsentAuthorization;
import de.adorsys.psd2.consent.domain.account.AspspAccountAccess;
import de.adorsys.psd2.consent.domain.account.TppAccountAccess;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.mapper.TppInfoMapper;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class AisConsentMapper {
    private final PsuDataMapper psuDataMapper;
    private final TppInfoMapper tppInfoMapper;

    public AisAccountConsent mapToAisAccountConsent(AisConsent consent) {
        return new AisAccountConsent(consent.getExternalId(), this.mapToAspspAisAccountAccess(consent.getAspspAccountAccesses()), consent.isRecurringIndicator(), consent.getExpireDate(), consent.getTppFrequencyPerDay(), consent.getLastActionDate(), consent.getConsentStatus(), consent.getAccesses().stream().anyMatch(a -> a.getTypeAccess() == TypeAccess.BALANCE), consent.isTppRedirectPreferred(), consent.getAisConsentRequestType(), this.psuDataMapper.mapToPsuIdData(consent.getPsuData()), this.tppInfoMapper.mapToTppInfo(consent.getTppInfo()));
    }

    public AisAccountConsent mapToInitialAisAccountConsent(AisConsent consent) {
        return new AisAccountConsent(consent.getExternalId(), this.mapToAisAccountAccess(consent.getAccesses()), consent.isRecurringIndicator(), consent.getExpireDate(), consent.getTppFrequencyPerDay(), consent.getLastActionDate(), consent.getConsentStatus(), consent.getAccesses().stream().anyMatch(a -> a.getTypeAccess() == TypeAccess.BALANCE), consent.isTppRedirectPreferred(), consent.getAisConsentRequestType(), this.psuDataMapper.mapToPsuIdData(consent.getPsuData()), this.tppInfoMapper.mapToTppInfo(consent.getTppInfo()));
    }

    public AisConsentAuthorizationResponse mapToAisConsentAuthorizationResponse(AisConsentAuthorization aisConsentAuthorization) {
        return Optional.ofNullable(aisConsentAuthorization).map(conAuth -> {
            AisConsentAuthorizationResponse resp = new AisConsentAuthorizationResponse();
            resp.setAuthorizationId(conAuth.getExternalId());
            resp.setPsuId((String)Optional.ofNullable(conAuth.getPsuData()).map(PsuData::getPsuId).orElse(null));
            resp.setConsentId(conAuth.getConsent().getExternalId());
            resp.setScaStatus(conAuth.getScaStatus());
            resp.setAuthenticationMethodId(conAuth.getAuthenticationMethodId());
            resp.setScaAuthenticationData(conAuth.getScaAuthenticationData());
            return resp;
        }).orElse(null);
    }

    private AisAccountAccess mapToAisAccountAccess(List<TppAccountAccess> accountAccesses) {
        return new AisAccountAccess(this.mapToInitialAccountReferences(accountAccesses, TypeAccess.ACCOUNT), this.mapToInitialAccountReferences(accountAccesses, TypeAccess.BALANCE), this.mapToInitialAccountReferences(accountAccesses, TypeAccess.TRANSACTION));
    }

    private List<AccountReference> mapToInitialAccountReferences(List<TppAccountAccess> aisAccounts, TypeAccess typeAccess) {
        return aisAccounts.stream().filter(a -> a.getTypeAccess() == typeAccess).map(access -> new AccountReference(access.getAccountReferenceType(), access.getAccountIdentifier(), access.getCurrency())).collect(Collectors.toList());
    }

    private AisAccountAccess mapToAspspAisAccountAccess(List<AspspAccountAccess> accountAccesses) {
        return new AisAccountAccess(this.mapToAccountReferences(accountAccesses, TypeAccess.ACCOUNT), this.mapToAccountReferences(accountAccesses, TypeAccess.BALANCE), this.mapToAccountReferences(accountAccesses, TypeAccess.TRANSACTION));
    }

    private List<AccountReference> mapToAccountReferences(List<AspspAccountAccess> aisAccounts, TypeAccess typeAccess) {
        return aisAccounts.stream().filter(a -> a.getTypeAccess() == typeAccess).map(access -> new AccountReference(access.getAccountReferenceType(), access.getAccountIdentifier(), access.getCurrency(), access.getResourceId(), access.getAspspAccountId())).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"psuDataMapper", "tppInfoMapper"})
    public AisConsentMapper(PsuDataMapper psuDataMapper, TppInfoMapper tppInfoMapper) {
        this.psuDataMapper = psuDataMapper;
        this.tppInfoMapper = tppInfoMapper;
    }
}

