/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.aspsp;

import de.adorsys.psd2.consent.api.pis.CmsPayment;
import de.adorsys.psd2.consent.aspsp.api.pis.CmsAspspPisExportService;
import de.adorsys.psd2.consent.repository.PisCommonPaymentDataRepository;
import de.adorsys.psd2.consent.repository.specification.PisCommonPaymentDataSpecification;
import de.adorsys.psd2.consent.service.mapper.CmsPsuPisMapper;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
public class CmsAspspPisExportServiceInternal
implements CmsAspspPisExportService {
    private final PisCommonPaymentDataSpecification pisCommonPaymentDataSpecification;
    private final PisCommonPaymentDataRepository pisCommonPaymentDataRepository;
    private final CmsPsuPisMapper cmsPsuPisMapper;

    public Collection<CmsPayment> exportPaymentsByTpp(String tppAuthorisationNumber, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable PsuIdData psuIdData, @NotNull String instanceId) {
        if (StringUtils.isBlank((CharSequence)tppAuthorisationNumber) || StringUtils.isBlank((CharSequence)instanceId)) {
            return Collections.emptyList();
        }
        List commonPayments = this.pisCommonPaymentDataRepository.findAll(this.pisCommonPaymentDataSpecification.byTppIdAndCreationPeriodAndPsuIdDataAndInstanceId(tppAuthorisationNumber, createDateFrom, createDateTo, psuIdData, instanceId));
        return this.cmsPsuPisMapper.mapPaymentDataToCmsPayments(commonPayments);
    }

    public Collection<CmsPayment> exportPaymentsByPsu(PsuIdData psuIdData, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @NotNull String instanceId) {
        if (psuIdData == null || psuIdData.isEmpty() || StringUtils.isBlank((CharSequence)instanceId)) {
            return Collections.emptyList();
        }
        List commonPayments = this.pisCommonPaymentDataRepository.findAll(this.pisCommonPaymentDataSpecification.byPsuIdDataAndCreationPeriodAndInstanceId(psuIdData, createDateFrom, createDateTo, instanceId));
        return this.cmsPsuPisMapper.mapPaymentDataToCmsPayments(commonPayments);
    }

    public Collection<CmsPayment> exportPaymentsByAccountIdAndTpp(@NotNull String aspspAccountId, @NotNull String tppAuthorisationNumber, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @NotNull String instanceId) {
        if (StringUtils.isBlank((CharSequence)aspspAccountId) || StringUtils.isBlank((CharSequence)tppAuthorisationNumber) || StringUtils.isBlank((CharSequence)instanceId)) {
            return Collections.emptyList();
        }
        List commonPayments = this.pisCommonPaymentDataRepository.findAll(this.pisCommonPaymentDataSpecification.byAspspAccountIdAndTppIdAndCreationPeriodAndInstanceId(aspspAccountId, tppAuthorisationNumber, createDateFrom, createDateTo, instanceId));
        return this.cmsPsuPisMapper.mapPaymentDataToCmsPayments(commonPayments);
    }

    @ConstructorProperties(value={"pisCommonPaymentDataSpecification", "pisCommonPaymentDataRepository", "cmsPsuPisMapper"})
    public CmsAspspPisExportServiceInternal(PisCommonPaymentDataSpecification pisCommonPaymentDataSpecification, PisCommonPaymentDataRepository pisCommonPaymentDataRepository, CmsPsuPisMapper cmsPsuPisMapper) {
        this.pisCommonPaymentDataSpecification = pisCommonPaymentDataSpecification;
        this.pisCommonPaymentDataRepository = pisCommonPaymentDataRepository;
        this.cmsPsuPisMapper = cmsPsuPisMapper;
    }
}

