/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.aspsp;

import de.adorsys.psd2.consent.api.ais.AisAccountConsent;
import de.adorsys.psd2.consent.aspsp.api.ais.CmsAspspAisExportService;
import de.adorsys.psd2.consent.repository.AisConsentRepository;
import de.adorsys.psd2.consent.repository.specification.AisConsentSpecification;
import de.adorsys.psd2.consent.service.mapper.AisConsentMapper;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
public class CmsAspspAisExportServiceInternal
implements CmsAspspAisExportService {
    private final AisConsentSpecification aisConsentSpecification;
    private final AisConsentRepository aisConsentRepository;
    private final AisConsentMapper aisConsentMapper;

    public Collection<AisAccountConsent> exportConsentsByTpp(String tppAuthorisationNumber, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @Nullable PsuIdData psuIdData, @NotNull String instanceId) {
        if (StringUtils.isBlank((CharSequence)tppAuthorisationNumber) || StringUtils.isBlank((CharSequence)instanceId)) {
            return Collections.emptyList();
        }
        return this.aisConsentRepository.findAll(this.aisConsentSpecification.byTppIdAndCreationPeriodAndPsuIdDataAndInstanceId(tppAuthorisationNumber, createDateFrom, createDateTo, psuIdData, instanceId)).stream().map(this.aisConsentMapper::mapToAisAccountConsent).collect(Collectors.toList());
    }

    public Collection<AisAccountConsent> exportConsentsByPsu(PsuIdData psuIdData, @Nullable LocalDate createDateFrom, @Nullable LocalDate createDateTo, @NotNull String instanceId) {
        if (psuIdData == null || psuIdData.isEmpty() || StringUtils.isBlank((CharSequence)instanceId)) {
            return Collections.emptyList();
        }
        return this.aisConsentRepository.findAll(this.aisConsentSpecification.byPsuIdDataAndCreationPeriodAndInstanceId(psuIdData, createDateFrom, createDateTo, instanceId)).stream().map(this.aisConsentMapper::mapToAisAccountConsent).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"aisConsentSpecification", "aisConsentRepository", "aisConsentMapper"})
    public CmsAspspAisExportServiceInternal(AisConsentSpecification aisConsentSpecification, AisConsentRepository aisConsentRepository, AisConsentMapper aisConsentMapper) {
        this.aisConsentSpecification = aisConsentSpecification;
        this.aisConsentRepository = aisConsentRepository;
        this.aisConsentMapper = aisConsentMapper;
    }
}

