/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.service.UpdatePaymentStatusAfterSpiService;
import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.domain.payment.PisPaymentData;
import de.adorsys.psd2.consent.repository.PisPaymentDataRepository;
import de.adorsys.psd2.consent.service.CommonPaymentDataService;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class UpdatePaymentStatusAfterSpiServiceInternal
implements UpdatePaymentStatusAfterSpiService {
    private static final Logger log = LoggerFactory.getLogger(UpdatePaymentStatusAfterSpiServiceInternal.class);
    private final PisPaymentDataRepository pisPaymentDataRepository;
    private final CommonPaymentDataService commonPaymentDataService;

    @Transactional
    public boolean updatePaymentStatus(@NotNull String paymentId, @NotNull TransactionStatus status) {
        Optional<List<PisPaymentData>> list = this.pisPaymentDataRepository.findByPaymentId(paymentId);
        if (list.isPresent()) {
            return this.updateStatusInPaymentDataList(list.get(), status);
        }
        Optional<PisCommonPaymentData> paymentDataOptional = this.commonPaymentDataService.getPisCommonPaymentData(paymentId, null);
        return paymentDataOptional.isPresent() && this.commonPaymentDataService.updateStatusInPaymentData(paymentDataOptional.get(), status);
    }

    private boolean updateStatusInPaymentDataList(List<PisPaymentData> payments, TransactionStatus newStatus) {
        if (CollectionUtils.isEmpty(payments)) {
            return false;
        }
        if (this.isChangingFinaliseStatus(payments, newStatus)) {
            return false;
        }
        for (PisPaymentData pisPaymentData : payments) {
            if (pisPaymentData.getTransactionStatus().isFinalisedStatus()) continue;
            pisPaymentData.setTransactionStatus(newStatus);
            this.pisPaymentDataRepository.save(pisPaymentData);
        }
        return true;
    }

    private boolean isChangingFinaliseStatus(List<PisPaymentData> payments, TransactionStatus newStatus) {
        return payments.stream().map(PisPaymentData::getTransactionStatus).filter(TransactionStatus::isFinalisedStatus).anyMatch(t -> t != newStatus);
    }

    @ConstructorProperties(value={"pisPaymentDataRepository", "commonPaymentDataService"})
    public UpdatePaymentStatusAfterSpiServiceInternal(PisPaymentDataRepository pisPaymentDataRepository, CommonPaymentDataService commonPaymentDataService) {
        this.pisPaymentDataRepository = pisPaymentDataRepository;
        this.commonPaymentDataService = commonPaymentDataService;
    }
}

