/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.consent.api.CmsAuthorisationType;
import de.adorsys.psd2.consent.api.pis.authorisation.CreatePisAuthorisationResponse;
import de.adorsys.psd2.consent.api.pis.authorisation.GetPisAuthorisationResponse;
import de.adorsys.psd2.consent.api.pis.authorisation.UpdatePisCommonPaymentPsuDataRequest;
import de.adorsys.psd2.consent.api.pis.authorisation.UpdatePisCommonPaymentPsuDataResponse;
import de.adorsys.psd2.consent.api.pis.proto.CreatePisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentRequest;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentInfo;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentService;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.payment.PisAuthorization;
import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.domain.payment.PisPaymentData;
import de.adorsys.psd2.consent.repository.PisAuthorizationRepository;
import de.adorsys.psd2.consent.repository.PisCommonPaymentDataRepository;
import de.adorsys.psd2.consent.repository.PisPaymentDataRepository;
import de.adorsys.psd2.consent.service.PisCommonPaymentConfirmationExpirationService;
import de.adorsys.psd2.consent.service.mapper.PisCommonPaymentMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PisCommonPaymentServiceInternal
implements PisCommonPaymentService {
    private static final Logger log = LoggerFactory.getLogger(PisCommonPaymentServiceInternal.class);
    private final PisCommonPaymentMapper pisCommonPaymentMapper;
    private final PsuDataMapper psuDataMapper;
    private final PisAuthorizationRepository pisAuthorizationRepository;
    private final PisPaymentDataRepository pisPaymentDataRepository;
    private final PisCommonPaymentDataRepository pisCommonPaymentDataRepository;
    private final AspspProfileService aspspProfileService;
    private final PisCommonPaymentConfirmationExpirationService pisCommonPaymentConfirmationExpirationService;

    @Transactional
    public Optional<CreatePisCommonPaymentResponse> createCommonPayment(PisPaymentInfo request) {
        PisCommonPaymentData commonPaymentData = this.pisCommonPaymentMapper.mapToPisCommonPaymentData(request);
        PisCommonPaymentData saved = (PisCommonPaymentData)this.pisCommonPaymentDataRepository.save(commonPaymentData);
        if (saved.getId() == null) {
            return Optional.empty();
        }
        return Optional.of(new CreatePisCommonPaymentResponse(saved.getPaymentId()));
    }

    @Transactional
    public Optional<TransactionStatus> getPisCommonPaymentStatusById(String paymentId) {
        return this.pisCommonPaymentDataRepository.findByPaymentId(paymentId).map(this.pisCommonPaymentConfirmationExpirationService::checkAndUpdatePaymentDataOnConfirmationExpiration).map(PisCommonPaymentData::getTransactionStatus);
    }

    @Transactional
    public Optional<PisCommonPaymentResponse> getCommonPaymentById(String paymentId) {
        return this.pisCommonPaymentDataRepository.findByPaymentId(paymentId).map(this.pisCommonPaymentConfirmationExpirationService::checkAndUpdatePaymentDataOnConfirmationExpiration).flatMap(this.pisCommonPaymentMapper::mapToPisCommonPaymentResponse);
    }

    @Transactional
    public Optional<Boolean> updateCommonPaymentStatusById(String paymentId, TransactionStatus status) {
        return this.pisCommonPaymentDataRepository.findByPaymentId(paymentId).map(this.pisCommonPaymentConfirmationExpirationService::checkAndUpdatePaymentDataOnConfirmationExpiration).filter(pm -> !pm.getTransactionStatus().isFinalisedStatus()).map(pmt -> this.setStatusAndSaveCommonPaymentData((PisCommonPaymentData)pmt, status)).map(con -> con.getTransactionStatus() == status);
    }

    @Transactional
    public Optional<CreatePisAuthorisationResponse> createAuthorization(String paymentId, CmsAuthorisationType authorizationType, PsuIdData psuData) {
        return this.readReceivedCommonPaymentDataByPaymentId(paymentId).map(pmt -> {
            this.closePreviousAuthorisationsByPsu(pmt.getAuthorizations(), authorizationType, psuData);
            return this.saveNewAuthorisation((PisCommonPaymentData)pmt, authorizationType, psuData);
        }).map(c -> new CreatePisAuthorisationResponse(c.getExternalId()));
    }

    @Transactional
    public Optional<CreatePisAuthorisationResponse> createAuthorizationCancellation(String paymentId, CmsAuthorisationType authorizationType, PsuIdData psuData) {
        return this.createAuthorization(paymentId, authorizationType, psuData);
    }

    @Transactional
    public Optional<UpdatePisCommonPaymentPsuDataResponse> updatePisAuthorisation(String authorizationId, UpdatePisCommonPaymentPsuDataRequest request) {
        Optional<PisAuthorization> pisAuthorisationOptional = this.pisAuthorizationRepository.findByExternalIdAndAuthorizationType(authorizationId, CmsAuthorisationType.CREATED);
        if (pisAuthorisationOptional.isPresent()) {
            ScaStatus scaStatus = this.doUpdateConsentAuthorisation(request, pisAuthorisationOptional.get());
            return Optional.of(new UpdatePisCommonPaymentPsuDataResponse(scaStatus));
        }
        return Optional.empty();
    }

    @Transactional
    public Optional<UpdatePisCommonPaymentPsuDataResponse> updatePisCancellationAuthorisation(String cancellationId, UpdatePisCommonPaymentPsuDataRequest request) {
        Optional<PisAuthorization> pisAuthorisationOptional = this.pisAuthorizationRepository.findByExternalIdAndAuthorizationType(cancellationId, CmsAuthorisationType.CANCELLED);
        if (pisAuthorisationOptional.isPresent()) {
            ScaStatus scaStatus = this.doUpdateConsentAuthorisation(request, pisAuthorisationOptional.get());
            return Optional.of(new UpdatePisCommonPaymentPsuDataResponse(scaStatus));
        }
        return Optional.empty();
    }

    @Transactional
    public void updateCommonPayment(PisCommonPaymentRequest request, String paymentId) {
        Optional<PisCommonPaymentData> pisCommonPaymentById = this.pisCommonPaymentDataRepository.findByPaymentId(paymentId);
        pisCommonPaymentById.ifPresent(commonPayment -> this.savePaymentData((PisCommonPaymentData)commonPayment, request));
    }

    public Optional<GetPisAuthorisationResponse> getPisAuthorisationById(String authorisationId) {
        return this.pisAuthorizationRepository.findByExternalIdAndAuthorizationType(authorisationId, CmsAuthorisationType.CREATED).map(this.pisCommonPaymentMapper::mapToGetPisAuthorizationResponse);
    }

    public Optional<GetPisAuthorisationResponse> getPisCancellationAuthorisationById(String cancellationId) {
        return this.pisAuthorizationRepository.findByExternalIdAndAuthorizationType(cancellationId, CmsAuthorisationType.CANCELLED).map(this.pisCommonPaymentMapper::mapToGetPisAuthorizationResponse);
    }

    public Optional<List<String>> getAuthorisationsByPaymentId(String paymentId, CmsAuthorisationType authorisationType) {
        return this.readReceivedCommonPaymentDataByPaymentId(paymentId).map(pmt -> this.readAuthorisationsFromPaymentCommonData((PisCommonPaymentData)pmt, authorisationType));
    }

    @Transactional
    public Optional<ScaStatus> getAuthorisationScaStatus(@NotNull String paymentId, @NotNull String authorisationId, CmsAuthorisationType authorisationType) {
        Optional<PisAuthorization> authorizationOptional = this.pisAuthorizationRepository.findByExternalIdAndAuthorizationType(authorisationId, authorisationType);
        if (!authorizationOptional.isPresent()) {
            return Optional.empty();
        }
        PisCommonPaymentData paymentData = authorizationOptional.get().getPaymentData();
        if (this.pisCommonPaymentConfirmationExpirationService.isPaymentDataOnConfirmationExpired(paymentData)) {
            this.pisCommonPaymentConfirmationExpirationService.updatePaymentDataOnConfirmationExpiration(paymentData);
            return Optional.of(ScaStatus.FAILED);
        }
        return authorizationOptional.filter(auth -> paymentId.equals(auth.getPaymentData().getPaymentId())).map(PisAuthorization::getScaStatus);
    }

    public Optional<List<PsuIdData>> getPsuDataListByPaymentId(String paymentId) {
        return this.readPisCommonPaymentDataByPaymentId(paymentId).map(pc -> this.psuDataMapper.mapToPsuIdDataList(pc.getPsuData()));
    }

    private PisCommonPaymentData setStatusAndSaveCommonPaymentData(PisCommonPaymentData commonPaymentData, TransactionStatus status) {
        commonPaymentData.setTransactionStatus(status);
        return (PisCommonPaymentData)this.pisCommonPaymentDataRepository.save(commonPaymentData);
    }

    private Optional<PisCommonPaymentData> readReceivedCommonPaymentDataByPaymentId(String paymentId) {
        Optional<PisCommonPaymentData> commonPaymentData = this.pisPaymentDataRepository.findByPaymentIdAndPaymentDataTransactionStatus(paymentId, TransactionStatus.RCVD).filter(CollectionUtils::isNotEmpty).map(list -> ((PisPaymentData)list.get(0)).getPaymentData()).map(this.pisCommonPaymentConfirmationExpirationService::checkAndUpdatePaymentDataOnConfirmationExpiration).filter(p -> p.getTransactionStatus() == TransactionStatus.RCVD);
        if (!commonPaymentData.isPresent()) {
            commonPaymentData = this.pisCommonPaymentDataRepository.findByPaymentIdAndTransactionStatus(paymentId, TransactionStatus.RCVD).map(this.pisCommonPaymentConfirmationExpirationService::checkAndUpdatePaymentDataOnConfirmationExpiration).filter(p -> p.getTransactionStatus() == TransactionStatus.RCVD);
        }
        return commonPaymentData;
    }

    private Optional<PisCommonPaymentData> readPisCommonPaymentDataByPaymentId(String paymentId) {
        Optional<PisCommonPaymentData> commonPaymentData = this.pisPaymentDataRepository.findByPaymentId(paymentId).filter(CollectionUtils::isNotEmpty).map(list -> ((PisPaymentData)list.get(0)).getPaymentData());
        if (!commonPaymentData.isPresent()) {
            commonPaymentData = this.pisCommonPaymentDataRepository.findByPaymentId(paymentId);
        }
        return commonPaymentData;
    }

    private void savePaymentData(PisCommonPaymentData pisCommonPayment, PisCommonPaymentRequest request) {
        boolean isCommonPayment;
        boolean bl = isCommonPayment = CollectionUtils.isEmpty((Collection)request.getPayments()) && request.getPaymentInfo() != null;
        if (isCommonPayment) {
            this.pisCommonPaymentDataRepository.save(this.pisCommonPaymentMapper.mapToPisCommonPaymentData(request.getPaymentInfo()));
        } else {
            this.pisPaymentDataRepository.save(this.pisCommonPaymentMapper.mapToPisPaymentDataList(request.getPayments(), pisCommonPayment));
        }
    }

    private PisAuthorization saveNewAuthorisation(PisCommonPaymentData paymentData, CmsAuthorisationType authorisationType, PsuIdData psuIdData) {
        PsuData psuData = this.psuDataMapper.mapToPsuData(psuIdData);
        PisAuthorization consentAuthorisation = new PisAuthorization();
        consentAuthorisation.setExternalId(UUID.randomUUID().toString());
        consentAuthorisation.setPaymentData(paymentData);
        consentAuthorisation.setScaStatus(ScaStatus.STARTED);
        consentAuthorisation.setAuthorizationType(authorisationType);
        consentAuthorisation.setRedirectUrlExpirationTimestamp(this.countRedirectUrlExpirationTimestampForAuthorisationType(authorisationType));
        consentAuthorisation.setPsuData(this.handlePsuForAuthorisation(psuData, paymentData.getPsuData()));
        consentAuthorisation.setPaymentData(this.enrichPsuData(psuData, paymentData));
        return (PisAuthorization)this.pisAuthorizationRepository.save(consentAuthorisation);
    }

    private OffsetDateTime countRedirectUrlExpirationTimestampForAuthorisationType(CmsAuthorisationType authorisationType) {
        long redirectUrlExpirationTimeMs = authorisationType == CmsAuthorisationType.CANCELLED ? this.aspspProfileService.getAspspSettings().getPaymentCancellationRedirectUrlExpirationTimeMs() : this.aspspProfileService.getAspspSettings().getRedirectUrlExpirationTimeMs();
        return OffsetDateTime.now().plus(redirectUrlExpirationTimeMs, ChronoUnit.MILLIS);
    }

    private void closePreviousAuthorisationsByPsu(List<PisAuthorization> authorisations, CmsAuthorisationType authorisationType, PsuIdData psuIdData) {
        PsuData psuData = this.psuDataMapper.mapToPsuData(psuIdData);
        if (!this.isPsuDataCorrect(psuData)) {
            return;
        }
        List pisAuthorisationList = authorisations.stream().filter(auth -> auth.getAuthorizationType() == authorisationType).filter(auth -> Objects.nonNull(auth.getPsuData()) && auth.getPsuData().contentEquals(psuData)).map(this::makeAuthorisationFailedAndExpired).collect(Collectors.toList());
        this.pisAuthorizationRepository.save(pisAuthorisationList);
    }

    private PisAuthorization makeAuthorisationFailedAndExpired(PisAuthorization auth) {
        auth.setScaStatus(ScaStatus.FAILED);
        auth.setRedirectUrlExpirationTimestamp(OffsetDateTime.now());
        return auth;
    }

    private PsuData handlePsuForAuthorisation(PsuData psuData, List<PsuData> psuDataList) {
        if (this.isPsuDataNew(psuData, psuDataList)) {
            return psuData;
        }
        if (this.isPsuDataInList(psuData, psuDataList)) {
            for (PsuData psu : psuDataList) {
                if (!psu.contentEquals(psuData)) continue;
                return psu;
            }
        }
        return null;
    }

    private PisCommonPaymentData enrichPsuData(PsuData psuData, PisCommonPaymentData paymentData) {
        List<PsuData> psuDataList = paymentData.getPsuData();
        if (this.isPsuDataNew(psuData, psuDataList)) {
            psuDataList.add(psuData);
            paymentData.setPsuData(psuDataList);
        }
        return paymentData;
    }

    private boolean isPsuDataNew(PsuData psuData, List<PsuData> psuDataList) {
        return !this.isPsuDataInList(psuData, psuDataList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isPsuDataInList(PsuData psuData, List<PsuData> psuDataList) {
        if (!this.isPsuDataCorrect(psuData)) return false;
        if (!psuDataList.stream().anyMatch(psuData::contentEquals)) return false;
        return true;
    }

    private boolean isPsuDataCorrect(PsuData psuData) {
        return Objects.nonNull(psuData) && StringUtils.isNotBlank((CharSequence)psuData.getPsuId());
    }

    private List<String> readAuthorisationsFromPaymentCommonData(PisCommonPaymentData paymentData, CmsAuthorisationType authorisationType) {
        return paymentData.getAuthorizations().stream().filter(auth -> auth.getAuthorizationType() == authorisationType).map(PisAuthorization::getExternalId).collect(Collectors.toList());
    }

    private ScaStatus doUpdateConsentAuthorisation(UpdatePisCommonPaymentPsuDataRequest request, PisAuthorization pisAuthorisation) {
        String chosenMethod;
        if (pisAuthorisation.getScaStatus().isFinalisedStatus()) {
            return pisAuthorisation.getScaStatus();
        }
        if (ScaStatus.SCAMETHODSELECTED == request.getScaStatus() && StringUtils.isNotBlank((CharSequence)(chosenMethod = request.getAuthenticationMethodId()))) {
            pisAuthorisation.setChosenScaMethod(chosenMethod);
        }
        pisAuthorisation.setScaStatus(request.getScaStatus());
        PisAuthorization saved = (PisAuthorization)this.pisAuthorizationRepository.save(pisAuthorisation);
        return saved.getScaStatus();
    }

    @ConstructorProperties(value={"pisCommonPaymentMapper", "psuDataMapper", "pisAuthorizationRepository", "pisPaymentDataRepository", "pisCommonPaymentDataRepository", "aspspProfileService", "pisCommonPaymentConfirmationExpirationService"})
    public PisCommonPaymentServiceInternal(PisCommonPaymentMapper pisCommonPaymentMapper, PsuDataMapper psuDataMapper, PisAuthorizationRepository pisAuthorizationRepository, PisPaymentDataRepository pisPaymentDataRepository, PisCommonPaymentDataRepository pisCommonPaymentDataRepository, AspspProfileService aspspProfileService, PisCommonPaymentConfirmationExpirationService pisCommonPaymentConfirmationExpirationService) {
        this.pisCommonPaymentMapper = pisCommonPaymentMapper;
        this.psuDataMapper = psuDataMapper;
        this.pisAuthorizationRepository = pisAuthorizationRepository;
        this.pisPaymentDataRepository = pisPaymentDataRepository;
        this.pisCommonPaymentDataRepository = pisCommonPaymentDataRepository;
        this.aspspProfileService = aspspProfileService;
        this.pisCommonPaymentConfirmationExpirationService = pisCommonPaymentConfirmationExpirationService;
    }
}

