/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.service.PiisConsentService;
import de.adorsys.psd2.consent.domain.piis.PiisConsentEntity;
import de.adorsys.psd2.consent.repository.PiisConsentRepository;
import de.adorsys.psd2.consent.service.mapper.PiisConsentMapper;
import de.adorsys.psd2.xs2a.core.piis.PiisConsent;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceSelector;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceType;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PiisConsentServiceInternal
implements PiisConsentService {
    private static final Logger log = LoggerFactory.getLogger(PiisConsentServiceInternal.class);
    private final PiisConsentRepository piisConsentRepository;
    private final PiisConsentMapper piisConsentMapper;

    public List<PiisConsent> getPiisConsentListByAccountIdentifier(Currency currency, AccountReferenceSelector accountReferenceSelector) {
        List<PiisConsentEntity> consents = this.extractPiisConsentList(currency, accountReferenceSelector);
        return this.piisConsentMapper.mapToPiisConsentList(consents);
    }

    private List<PiisConsentEntity> extractPiisConsentList(Currency currency, AccountReferenceSelector accountReferenceSelector) {
        AccountReferenceType accountReferenceType = accountReferenceSelector.getAccountReferenceType();
        String accountReferenceValue = accountReferenceSelector.getAccountValue();
        if (accountReferenceType == AccountReferenceType.IBAN) {
            return this.piisConsentRepository.findAllByAccountsIbanAndAccountsCurrency(accountReferenceValue, currency);
        }
        if (accountReferenceType == AccountReferenceType.BBAN) {
            return this.piisConsentRepository.findAllByAccountsBbanAndAccountsCurrency(accountReferenceValue, currency);
        }
        if (accountReferenceType == AccountReferenceType.MSISDN) {
            return this.piisConsentRepository.findAllByAccountsMsisdnAndAccountsCurrency(accountReferenceValue, currency);
        }
        if (accountReferenceType == AccountReferenceType.MASKED_PAN) {
            return this.piisConsentRepository.findAllByAccountsMaskedPanAndAccountsCurrency(accountReferenceValue, currency);
        }
        if (accountReferenceType == AccountReferenceType.PAN) {
            return this.piisConsentRepository.findAllByAccountsPanAndAccountsCurrency(accountReferenceValue, currency);
        }
        log.warn("Account identifier is unknown!");
        return Collections.emptyList();
    }

    @ConstructorProperties(value={"piisConsentRepository", "piisConsentMapper"})
    public PiisConsentServiceInternal(PiisConsentRepository piisConsentRepository, PiisConsentMapper piisConsentMapper) {
        this.piisConsentRepository = piisConsentRepository;
        this.piisConsentMapper = piisConsentMapper;
    }
}

