/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.service.EventService;
import de.adorsys.psd2.consent.api.service.EventServiceEncrypted;
import de.adorsys.psd2.consent.service.security.SecurityDataService;
import de.adorsys.psd2.xs2a.core.event.Event;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EventServiceInternalEncrypted
implements EventServiceEncrypted {
    private final SecurityDataService securityDataService;
    private final EventService eventService;

    @Transactional
    public boolean recordEvent(@NotNull Event event) {
        String decryptedConsentId = this.decryptId(event.getConsentId());
        String decryptedPaymentId = this.decryptId(event.getPaymentId());
        Event decryptedEvent = Event.builder().timestamp(event.getTimestamp()).consentId(decryptedConsentId).paymentId(decryptedPaymentId).payload(event.getPayload()).eventOrigin(event.getEventOrigin()).eventType(event.getEventType()).build();
        return this.eventService.recordEvent(decryptedEvent);
    }

    private String decryptId(String id) {
        return Optional.ofNullable(id).flatMap(this.securityDataService::decryptId).orElse(null);
    }

    @ConstructorProperties(value={"securityDataService", "eventService"})
    public EventServiceInternalEncrypted(SecurityDataService securityDataService, EventService eventService) {
        this.securityDataService = securityDataService;
        this.eventService = eventService;
    }
}

