/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.aspsp.api.tpp.CmsAspspTppService;
import de.adorsys.psd2.consent.domain.TppStopListEntity;
import de.adorsys.psd2.consent.repository.TppStopListRepository;
import de.adorsys.psd2.consent.service.mapper.TppStopListMapper;
import de.adorsys.psd2.xs2a.core.tpp.TppStopListRecord;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CmsAspspTppServiceInternal
implements CmsAspspTppService {
    private final TppStopListRepository stopListRepository;
    private final TppStopListMapper tppStopListMapper;

    @NotNull
    public Optional<TppStopListRecord> getTppStopListRecord(@NotNull String tppAuthorisationNumber, @NotNull String nationalAuthorityId, @NotNull String instanceId) {
        Optional<TppStopListEntity> stopListEntityOptional = this.stopListRepository.findByTppAuthorisationNumberAndNationalAuthorityIdAndInstanceId(tppAuthorisationNumber, nationalAuthorityId, instanceId);
        return stopListEntityOptional.map(this.tppStopListMapper::mapToTppStopListRecord);
    }

    @Transactional
    public boolean blockTpp(@NotNull String tppAuthorisationNumber, @NotNull String nationalAuthorityId, @NotNull String instanceId, @Nullable Duration lockPeriod) {
        Optional<TppStopListEntity> stopListEntityOptional = this.stopListRepository.findByTppAuthorisationNumberAndNationalAuthorityIdAndInstanceId(tppAuthorisationNumber, nationalAuthorityId, instanceId);
        TppStopListEntity entityToBeBlocked = stopListEntityOptional.orElseGet(() -> {
            TppStopListEntity entity = new TppStopListEntity();
            entity.setTppAuthorisationNumber(tppAuthorisationNumber);
            entity.setNationalAuthorityId(nationalAuthorityId);
            return entity;
        });
        entityToBeBlocked.block(lockPeriod);
        this.stopListRepository.save(entityToBeBlocked);
        return true;
    }

    @Transactional
    public boolean unblockTpp(@NotNull String tppAuthorisationNumber, @NotNull String nationalAuthorityId, @NotNull String instanceId) {
        Optional<TppStopListEntity> stopListEntityOptional = this.stopListRepository.findByTppAuthorisationNumberAndNationalAuthorityIdAndInstanceId(tppAuthorisationNumber, nationalAuthorityId, instanceId);
        if (!stopListEntityOptional.isPresent()) {
            return true;
        }
        TppStopListEntity entityToBeUnblocked = stopListEntityOptional.get();
        entityToBeUnblocked.unblock();
        this.stopListRepository.save(entityToBeUnblocked);
        return true;
    }

    @ConstructorProperties(value={"stopListRepository", "tppStopListMapper"})
    public CmsAspspTppServiceInternal(TppStopListRepository stopListRepository, TppStopListMapper tppStopListMapper) {
        this.stopListRepository = stopListRepository;
        this.tppStopListMapper = tppStopListMapper;
    }
}

