/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.aspsp.api.CmsAspspEventService;
import de.adorsys.psd2.consent.domain.event.EventEntity;
import de.adorsys.psd2.consent.repository.EventRepository;
import de.adorsys.psd2.consent.repository.specification.EventEntitySpecification;
import de.adorsys.psd2.consent.service.mapper.EventMapper;
import de.adorsys.psd2.xs2a.core.event.Event;
import de.adorsys.psd2.xs2a.core.event.EventOrigin;
import de.adorsys.psd2.xs2a.core.event.EventType;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CmsAspspEventServiceInternal
implements CmsAspspEventService {
    private final EventRepository eventRepository;
    private final EventMapper eventMapper;
    private final EventEntitySpecification eventEntitySpecification;

    public List<Event> getEventsForPeriod(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end, @Nullable String instanceId) {
        List eventEntity = this.eventRepository.findAll(this.eventEntitySpecification.byPeriodAndInstanceId(start, end, instanceId));
        return this.eventMapper.mapToEventList(eventEntity);
    }

    public List<Event> getEventsForPeriodAndConsentId(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end, @NotNull String consentId, @Nullable String instanceId) {
        List eventEntity = this.eventRepository.findAll(this.eventEntitySpecification.byPeriodAndConsentIdAndInstanceId(start, end, consentId, instanceId));
        return this.eventMapper.mapToEventList(eventEntity);
    }

    public List<Event> getEventsForPeriodAndPaymentId(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end, @NotNull String paymentId, @Nullable String instanceId) {
        List eventEntity = this.eventRepository.findAll(this.eventEntitySpecification.byPeriodAndPaymentIdAndInstanceId(start, end, paymentId, instanceId));
        return this.eventMapper.mapToEventList(eventEntity);
    }

    public List<Event> getEventsForPeriodAndEventType(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end, @NotNull EventType eventType, @Nullable String instanceId) {
        List<EventEntity> eventEntity = this.eventRepository.findByTimestampBetweenAndEventTypeOrderByTimestampAsc(start, end, eventType);
        return this.eventMapper.mapToEventList(eventEntity);
    }

    public List<Event> getEventsForPeriodAndEventOrigin(@NotNull OffsetDateTime start, @NotNull OffsetDateTime end, @NotNull EventOrigin eventOrigin, @Nullable String instanceId) {
        List<EventEntity> eventEntity = this.eventRepository.findByTimestampBetweenAndEventOriginOrderByTimestampAsc(start, end, eventOrigin);
        return this.eventMapper.mapToEventList(eventEntity);
    }

    @ConstructorProperties(value={"eventRepository", "eventMapper", "eventEntitySpecification"})
    public CmsAspspEventServiceInternal(EventRepository eventRepository, EventMapper eventMapper, EventEntitySpecification eventEntitySpecification) {
        this.eventRepository = eventRepository;
        this.eventMapper = eventMapper;
        this.eventEntitySpecification = eventEntitySpecification;
    }
}

