/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.consent.api.ActionStatus;
import de.adorsys.psd2.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.psd2.consent.api.ais.AisAccountAccessType;
import de.adorsys.psd2.consent.api.ais.AisAccountConsent;
import de.adorsys.psd2.consent.api.ais.AisConsentActionRequest;
import de.adorsys.psd2.consent.api.ais.AisConsentAuthorizationRequest;
import de.adorsys.psd2.consent.api.ais.AisConsentAuthorizationResponse;
import de.adorsys.psd2.consent.api.ais.CreateAisConsentRequest;
import de.adorsys.psd2.consent.api.service.AisConsentService;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.domain.account.AisConsentAction;
import de.adorsys.psd2.consent.domain.account.AisConsentAuthorization;
import de.adorsys.psd2.consent.domain.account.AspspAccountAccessHolder;
import de.adorsys.psd2.consent.domain.account.TppAccountAccessHolder;
import de.adorsys.psd2.consent.repository.AisConsentActionRepository;
import de.adorsys.psd2.consent.repository.AisConsentAuthorizationRepository;
import de.adorsys.psd2.consent.repository.AisConsentRepository;
import de.adorsys.psd2.consent.service.AisConsentConfirmationExpirationService;
import de.adorsys.psd2.consent.service.mapper.AisConsentMapper;
import de.adorsys.psd2.consent.service.mapper.PsuDataMapper;
import de.adorsys.psd2.consent.service.mapper.TppInfoMapper;
import de.adorsys.psd2.xs2a.core.consent.AisConsentRequestType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AisConsentServiceInternal
implements AisConsentService {
    private final AisConsentRepository aisConsentRepository;
    private final AisConsentActionRepository aisConsentActionRepository;
    private final AisConsentAuthorizationRepository aisConsentAuthorizationRepository;
    private final AisConsentMapper consentMapper;
    private final PsuDataMapper psuDataMapper;
    private final AspspProfileService aspspProfileService;
    private final AisConsentConfirmationExpirationService aisConsentConfirmationExpirationService;
    private final TppInfoMapper tppInfoMapper;

    @Transactional
    public Optional<String> createConsent(CreateAisConsentRequest request) {
        if (request.getAllowedFrequencyPerDay() == null) {
            return Optional.empty();
        }
        AisConsent consent = this.createConsentFromRequest(request);
        consent.setExternalId(UUID.randomUUID().toString());
        AisConsent saved = (AisConsent)this.aisConsentRepository.save(consent);
        return saved.getId() != null ? Optional.of(saved.getExternalId()) : Optional.empty();
    }

    @Transactional
    public Optional<ConsentStatus> getConsentStatusById(String consentId) {
        return this.aisConsentRepository.findByExternalId(consentId).map(this.aisConsentConfirmationExpirationService::checkAndUpdateOnConfirmationExpiration).map(this::checkAndUpdateOnExpiration).map(AisConsent::getConsentStatus);
    }

    @Transactional
    public boolean updateConsentStatusById(String consentId, ConsentStatus status) {
        return this.getActualAisConsent(consentId).map(c -> this.setStatusAndSaveConsent((AisConsent)c, status)).orElse(false);
    }

    @Transactional
    public Optional<AisAccountConsent> getAisAccountConsentById(String consentId) {
        return this.aisConsentRepository.findByExternalId(consentId).map(this.aisConsentConfirmationExpirationService::checkAndUpdateOnConfirmationExpiration).map(this::checkAndUpdateOnExpiration).map(this.consentMapper::mapToAisAccountConsent);
    }

    public Optional<AisAccountConsent> getInitialAisAccountConsentById(String consentId) {
        return this.aisConsentRepository.findByExternalId(consentId).map(this::checkAndUpdateOnExpiration).map(this.consentMapper::mapToInitialAisAccountConsent);
    }

    @Transactional
    public void checkConsentAndSaveActionLog(AisConsentActionRequest request) {
        Optional<AisConsent> consentOpt = this.getActualAisConsent(request.getConsentId());
        if (consentOpt.isPresent()) {
            AisConsent consent = consentOpt.get();
            this.aisConsentConfirmationExpirationService.checkAndUpdateOnConfirmationExpiration(consent);
            this.checkAndUpdateOnExpiration(consent);
            this.updateAisConsentCounter(consent);
            this.logConsentAction(consent.getExternalId(), this.resolveConsentActionStatus(request, consent), request.getTppId());
        }
    }

    @Transactional
    public Optional<String> updateAspspAccountAccess(String consentId, AisAccountAccessInfo request) {
        return this.getActualAisConsent(consentId).map(consent -> {
            consent.addAspspAccountAccess(new AspspAccountAccessHolder(request).getAccountAccesses());
            return ((AisConsent)this.aisConsentRepository.save(consent)).getExternalId();
        });
    }

    @Transactional
    public Optional<String> createAuthorization(String consentId, AisConsentAuthorizationRequest request) {
        return this.aisConsentRepository.findByExternalId(consentId).filter(con -> !con.getConsentStatus().isFinalisedStatus()).map(aisConsent -> {
            this.closePreviousAuthorisationsByPsu(aisConsent.getAuthorizations(), request.getPsuData());
            return this.saveNewAuthorization((AisConsent)aisConsent, request);
        });
    }

    public Optional<AisConsentAuthorizationResponse> getAccountConsentAuthorizationById(String authorizationId, String consentId) {
        boolean consentPresent = this.aisConsentRepository.findByExternalId(consentId).filter(c -> !c.getConsentStatus().isFinalisedStatus()).isPresent();
        return consentPresent ? this.aisConsentAuthorizationRepository.findByExternalId(authorizationId).map(this.consentMapper::mapToAisConsentAuthorizationResponse) : Optional.empty();
    }

    public Optional<List<String>> getAuthorisationsByConsentId(String consentId) {
        return this.aisConsentRepository.findByExternalId(consentId).map(cst -> cst.getAuthorizations().stream().map(AisConsentAuthorization::getExternalId).collect(Collectors.toList()));
    }

    @Transactional
    public Optional<ScaStatus> getAuthorisationScaStatus(String consentId, String authorisationId) {
        Optional<AisConsent> consentOptional = this.aisConsentRepository.findByExternalId(consentId);
        if (!consentOptional.isPresent()) {
            return Optional.empty();
        }
        AisConsent consent = consentOptional.get();
        if (this.aisConsentConfirmationExpirationService.isConsentConfirmationExpired(consent)) {
            this.aisConsentConfirmationExpirationService.updateConsentOnConfirmationExpiration(consent);
            return Optional.of(ScaStatus.FAILED);
        }
        Optional<AisConsentAuthorization> authorisation = this.findAuthorisationInConsent(authorisationId, consent);
        return authorisation.map(AisConsentAuthorization::getScaStatus);
    }

    @Transactional
    public boolean updateConsentAuthorization(String authorizationId, AisConsentAuthorizationRequest request) {
        Optional<AisConsentAuthorization> aisConsentAuthorizationOptional = this.aisConsentAuthorizationRepository.findByExternalId(authorizationId);
        if (!aisConsentAuthorizationOptional.isPresent()) {
            return false;
        }
        AisConsentAuthorization aisConsentAuthorization = aisConsentAuthorizationOptional.get();
        if (aisConsentAuthorization.getScaStatus().isFinalisedStatus()) {
            return false;
        }
        if (ScaStatus.STARTED == aisConsentAuthorization.getScaStatus()) {
            aisConsentAuthorization.setPsuData(this.psuDataMapper.mapToPsuData(request.getPsuData()));
        }
        if (ScaStatus.SCAMETHODSELECTED == request.getScaStatus()) {
            aisConsentAuthorization.setAuthenticationMethodId(request.getAuthenticationMethodId());
        }
        aisConsentAuthorization.setScaStatus(request.getScaStatus());
        aisConsentAuthorization = (AisConsentAuthorization)this.aisConsentAuthorizationRepository.save(aisConsentAuthorization);
        return aisConsentAuthorization.getExternalId() != null;
    }

    public Optional<PsuIdData> getPsuDataByConsentId(String consentId) {
        return this.getActualAisConsent(consentId).map(ac -> this.psuDataMapper.mapToPsuIdData(ac.getPsuData()));
    }

    private AisConsent createConsentFromRequest(CreateAisConsentRequest request) {
        AisConsent consent = new AisConsent();
        consent.setConsentStatus(ConsentStatus.RECEIVED);
        consent.setAllowedFrequencyPerDay(request.getAllowedFrequencyPerDay());
        consent.setTppFrequencyPerDay(request.getRequestedFrequencyPerDay());
        consent.setUsageCounter(request.getAllowedFrequencyPerDay());
        consent.setRequestDateTime(LocalDateTime.now());
        consent.setExpireDate(request.getValidUntil());
        consent.setPsuData(this.psuDataMapper.mapToPsuData(request.getPsuData()));
        consent.setTppInfo(this.tppInfoMapper.mapToTppInfoEntity(request.getTppInfo()));
        consent.addAccountAccess(new TppAccountAccessHolder(request.getAccess()).getAccountAccesses());
        consent.setRecurringIndicator(request.isRecurringIndicator());
        consent.setTppRedirectPreferred(request.isTppRedirectPreferred());
        consent.setCombinedServiceIndicator(request.isCombinedServiceIndicator());
        consent.setAisConsentRequestType(this.getRequestTypeFromAccess(request.getAccess()));
        return consent;
    }

    private AisConsentRequestType getRequestTypeFromAccess(AisAccountAccessInfo accessInfo) {
        if (accessInfo.getAllPsd2() == AisAccountAccessType.ALL_ACCOUNTS) {
            return AisConsentRequestType.GLOBAL;
        }
        if (EnumSet.of(AisAccountAccessType.ALL_ACCOUNTS, AisAccountAccessType.ALL_ACCOUNTS_WITH_BALANCES).contains(accessInfo.getAvailableAccounts())) {
            return AisConsentRequestType.ALL_AVAILABLE_ACCOUNTS;
        }
        if (this.isEmptyAccess(accessInfo)) {
            return AisConsentRequestType.BANK_OFFERED;
        }
        return AisConsentRequestType.DEDICATED_ACCOUNTS;
    }

    private boolean isEmptyAccess(AisAccountAccessInfo accessInfo) {
        return CollectionUtils.isEmpty((Collection)accessInfo.getAccounts()) && CollectionUtils.isEmpty((Collection)accessInfo.getBalances()) && CollectionUtils.isEmpty((Collection)accessInfo.getTransactions());
    }

    private ActionStatus resolveConsentActionStatus(AisConsentActionRequest request, AisConsent consent) {
        return consent == null ? ActionStatus.BAD_PAYLOAD : request.getActionStatus();
    }

    private void updateAisConsentCounter(AisConsent consent) {
        if (consent != null && consent.hasUsagesAvailable()) {
            int usageCounter = consent.getUsageCounter();
            int newUsageCounter = --usageCounter;
            consent.setUsageCounter(newUsageCounter);
            consent.setLastActionDate(LocalDate.now());
            this.aisConsentRepository.save(consent);
        }
    }

    private void logConsentAction(String requestedConsentId, ActionStatus actionStatus, String tppId) {
        AisConsentAction action = new AisConsentAction();
        action.setActionStatus(actionStatus);
        action.setRequestedConsentId(requestedConsentId);
        action.setTppId(tppId);
        action.setRequestDate(LocalDate.now());
        this.aisConsentActionRepository.save(action);
    }

    private Optional<AisConsent> getActualAisConsent(String consentId) {
        return this.aisConsentRepository.findByExternalId(consentId).filter(c -> !c.getConsentStatus().isFinalisedStatus());
    }

    private AisConsent checkAndUpdateOnExpiration(AisConsent consent) {
        if (consent != null && consent.isExpiredByDate() && consent.isStatusNotExpired()) {
            consent.setConsentStatus(ConsentStatus.EXPIRED);
            consent.setExpireDate(LocalDate.now());
            consent.setLastActionDate(LocalDate.now());
            this.aisConsentRepository.save(consent);
        }
        return consent;
    }

    private boolean setStatusAndSaveConsent(AisConsent consent, ConsentStatus status) {
        if (consent.getConsentStatus().isFinalisedStatus()) {
            return false;
        }
        consent.setLastActionDate(LocalDate.now());
        consent.setConsentStatus(status);
        return Optional.ofNullable(this.aisConsentRepository.save(consent)).isPresent();
    }

    private String saveNewAuthorization(AisConsent aisConsent, AisConsentAuthorizationRequest request) {
        AisConsentAuthorization consentAuthorization = new AisConsentAuthorization();
        consentAuthorization.setExternalId(UUID.randomUUID().toString());
        consentAuthorization.setPsuData(this.psuDataMapper.mapToPsuData(request.getPsuData()));
        consentAuthorization.setConsent(aisConsent);
        consentAuthorization.setScaStatus(request.getScaStatus());
        consentAuthorization.setRedirectUrlExpirationTimestamp(OffsetDateTime.now().plus(this.aspspProfileService.getAspspSettings().getRedirectUrlExpirationTimeMs(), ChronoUnit.MILLIS));
        return ((AisConsentAuthorization)this.aisConsentAuthorizationRepository.save(consentAuthorization)).getExternalId();
    }

    private Optional<AisConsentAuthorization> findAuthorisationInConsent(String authorisationId, AisConsent consent) {
        return consent.getAuthorizations().stream().filter(auth -> auth.getExternalId().equals(authorisationId)).findFirst();
    }

    private void closePreviousAuthorisationsByPsu(List<AisConsentAuthorization> authorisations, PsuIdData psuIdData) {
        PsuData psuData = this.psuDataMapper.mapToPsuData(psuIdData);
        if (!this.isPsuDataCorrect(psuData)) {
            return;
        }
        List aisConsentAuthorisations = authorisations.stream().filter(auth -> Objects.nonNull(auth.getPsuData()) && auth.getPsuData().contentEquals(psuData)).map(this::makeAuthorisationFailedAndExpired).collect(Collectors.toList());
        this.aisConsentAuthorizationRepository.save(aisConsentAuthorisations);
    }

    private boolean isPsuDataCorrect(PsuData psuData) {
        return Objects.nonNull(psuData) && StringUtils.isNotBlank((CharSequence)psuData.getPsuId());
    }

    private AisConsentAuthorization makeAuthorisationFailedAndExpired(AisConsentAuthorization auth) {
        auth.setScaStatus(ScaStatus.FAILED);
        auth.setRedirectUrlExpirationTimestamp(OffsetDateTime.now());
        return auth;
    }

    @ConstructorProperties(value={"aisConsentRepository", "aisConsentActionRepository", "aisConsentAuthorizationRepository", "consentMapper", "psuDataMapper", "aspspProfileService", "aisConsentConfirmationExpirationService", "tppInfoMapper"})
    public AisConsentServiceInternal(AisConsentRepository aisConsentRepository, AisConsentActionRepository aisConsentActionRepository, AisConsentAuthorizationRepository aisConsentAuthorizationRepository, AisConsentMapper consentMapper, PsuDataMapper psuDataMapper, AspspProfileService aspspProfileService, AisConsentConfirmationExpirationService aisConsentConfirmationExpirationService, TppInfoMapper tppInfoMapper) {
        this.aisConsentRepository = aisConsentRepository;
        this.aisConsentActionRepository = aisConsentActionRepository;
        this.aisConsentAuthorizationRepository = aisConsentAuthorizationRepository;
        this.consentMapper = consentMapper;
        this.psuDataMapper = psuDataMapper;
        this.aspspProfileService = aspspProfileService;
        this.aisConsentConfirmationExpirationService = aisConsentConfirmationExpirationService;
        this.tppInfoMapper = tppInfoMapper;
    }
}

