/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain.payment;

import de.adorsys.psd2.consent.domain.InstanceDependableEntity;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.TppInfoEntity;
import de.adorsys.psd2.consent.domain.payment.PisAuthorization;
import de.adorsys.psd2.consent.domain.payment.PisPaymentData;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;

@Entity(name="pis_common_payment")
@ApiModel(description="pis common payment entity", value="PisCommonPaymentData")
public class PisCommonPaymentData
extends InstanceDependableEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="pis_common_payment_generator")
    @SequenceGenerator(name="pis_common_payment_generator", sequenceName="pis_common_payment_id_seq")
    private Long id;
    @Column(name="payment_id", nullable=false)
    private String paymentId;
    @Column(name="payment_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(value="Payment type: BULK, SINGLE or PERIODIC.", required=true, example="SINGLE")
    private PaymentType paymentType;
    @Column(name="payment_product", nullable=false)
    @ApiModelProperty(value="Payment product", required=true, example="sepa-credit-transfers")
    private String paymentProduct;
    @Column(name="transaction_status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @ApiModelProperty(name="transactionStatus", example="ACCP", required=true)
    private TransactionStatus transactionStatus;
    @Lob
    @Column(name="payment", nullable=false)
    @ApiModelProperty(value="All data about the payment", required=true)
    private byte[] payment;
    @OneToMany(cascade={CascadeType.ALL})
    @ApiModelProperty(value="List of PSU", required=true)
    private List<PsuData> psuData = new ArrayList<PsuData>();
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="tpp_info_id", nullable=false)
    @ApiModelProperty(value="Information about TPP", required=true)
    private TppInfoEntity tppInfo;
    @OneToMany(mappedBy="paymentData", cascade={CascadeType.ALL}, orphanRemoval=true)
    @ApiModelProperty(value="List of authorizations", required=true)
    private List<PisAuthorization> authorizations = new ArrayList<PisAuthorization>();
    @OneToMany(mappedBy="paymentData", cascade={CascadeType.ALL}, orphanRemoval=true)
    @ApiModelProperty(value="List of single payments ", required=true)
    private List<PisPaymentData> payments = new ArrayList<PisPaymentData>();
    @Column(name="creation_timestamp")
    @ApiModelProperty(value="Creation timestamp of the consent.", required=true, example="2018-12-28T00:00:00Z")
    private OffsetDateTime creationTimestamp = OffsetDateTime.now();
    @Column(name="aspsp_account_id", length=100)
    @ApiModelProperty(value="Aspsp-Account-ID: Bank specific account ID", example="26bb59a3-2f63-4027-ad38-67d87e59611a")
    private String aspspAccountId;

    public boolean isConfirmationExpired(long expirationPeriodMs) {
        if (this.isNotConfirmed()) {
            return this.creationTimestamp.plus(expirationPeriodMs, ChronoUnit.MILLIS).isBefore(OffsetDateTime.now());
        }
        return false;
    }

    public boolean isNotConfirmed() {
        return this.transactionStatus == TransactionStatus.RCVD;
    }

    public Long getId() {
        return this.id;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public String getPaymentProduct() {
        return this.paymentProduct;
    }

    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public byte[] getPayment() {
        return this.payment;
    }

    public List<PsuData> getPsuData() {
        return this.psuData;
    }

    public TppInfoEntity getTppInfo() {
        return this.tppInfo;
    }

    public List<PisAuthorization> getAuthorizations() {
        return this.authorizations;
    }

    public List<PisPaymentData> getPayments() {
        return this.payments;
    }

    public OffsetDateTime getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String getAspspAccountId() {
        return this.aspspAccountId;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    public void setPaymentProduct(String paymentProduct) {
        this.paymentProduct = paymentProduct;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public void setPayment(byte[] payment) {
        this.payment = payment;
    }

    public void setPsuData(List<PsuData> psuData) {
        this.psuData = psuData;
    }

    public void setTppInfo(TppInfoEntity tppInfo) {
        this.tppInfo = tppInfo;
    }

    public void setAuthorizations(List<PisAuthorization> authorizations) {
        this.authorizations = authorizations;
    }

    public void setPayments(List<PisPaymentData> payments) {
        this.payments = payments;
    }

    public void setCreationTimestamp(OffsetDateTime creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public void setAspspAccountId(String aspspAccountId) {
        this.aspspAccountId = aspspAccountId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PisCommonPaymentData)) {
            return false;
        }
        PisCommonPaymentData other = (PisCommonPaymentData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$paymentId = this.getPaymentId();
        String other$paymentId = other.getPaymentId();
        if (this$paymentId == null ? other$paymentId != null : !this$paymentId.equals(other$paymentId)) {
            return false;
        }
        PaymentType this$paymentType = this.getPaymentType();
        PaymentType other$paymentType = other.getPaymentType();
        if (this$paymentType == null ? other$paymentType != null : !this$paymentType.equals(other$paymentType)) {
            return false;
        }
        String this$paymentProduct = this.getPaymentProduct();
        String other$paymentProduct = other.getPaymentProduct();
        if (this$paymentProduct == null ? other$paymentProduct != null : !this$paymentProduct.equals(other$paymentProduct)) {
            return false;
        }
        TransactionStatus this$transactionStatus = this.getTransactionStatus();
        TransactionStatus other$transactionStatus = other.getTransactionStatus();
        if (this$transactionStatus == null ? other$transactionStatus != null : !this$transactionStatus.equals(other$transactionStatus)) {
            return false;
        }
        if (!Arrays.equals(this.getPayment(), other.getPayment())) {
            return false;
        }
        List<PsuData> this$psuData = this.getPsuData();
        List<PsuData> other$psuData = other.getPsuData();
        if (this$psuData == null ? other$psuData != null : !((Object)this$psuData).equals(other$psuData)) {
            return false;
        }
        TppInfoEntity this$tppInfo = this.getTppInfo();
        TppInfoEntity other$tppInfo = other.getTppInfo();
        if (this$tppInfo == null ? other$tppInfo != null : !((Object)this$tppInfo).equals(other$tppInfo)) {
            return false;
        }
        List<PisAuthorization> this$authorizations = this.getAuthorizations();
        List<PisAuthorization> other$authorizations = other.getAuthorizations();
        if (this$authorizations == null ? other$authorizations != null : !((Object)this$authorizations).equals(other$authorizations)) {
            return false;
        }
        List<PisPaymentData> this$payments = this.getPayments();
        List<PisPaymentData> other$payments = other.getPayments();
        if (this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments)) {
            return false;
        }
        OffsetDateTime this$creationTimestamp = this.getCreationTimestamp();
        OffsetDateTime other$creationTimestamp = other.getCreationTimestamp();
        if (this$creationTimestamp == null ? other$creationTimestamp != null : !((Object)this$creationTimestamp).equals(other$creationTimestamp)) {
            return false;
        }
        String this$aspspAccountId = this.getAspspAccountId();
        String other$aspspAccountId = other.getAspspAccountId();
        return !(this$aspspAccountId == null ? other$aspspAccountId != null : !this$aspspAccountId.equals(other$aspspAccountId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PisCommonPaymentData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $paymentId = this.getPaymentId();
        result = result * 59 + ($paymentId == null ? 43 : $paymentId.hashCode());
        PaymentType $paymentType = this.getPaymentType();
        result = result * 59 + ($paymentType == null ? 43 : $paymentType.hashCode());
        String $paymentProduct = this.getPaymentProduct();
        result = result * 59 + ($paymentProduct == null ? 43 : $paymentProduct.hashCode());
        TransactionStatus $transactionStatus = this.getTransactionStatus();
        result = result * 59 + ($transactionStatus == null ? 43 : $transactionStatus.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPayment());
        List<PsuData> $psuData = this.getPsuData();
        result = result * 59 + ($psuData == null ? 43 : ((Object)$psuData).hashCode());
        TppInfoEntity $tppInfo = this.getTppInfo();
        result = result * 59 + ($tppInfo == null ? 43 : ((Object)$tppInfo).hashCode());
        List<PisAuthorization> $authorizations = this.getAuthorizations();
        result = result * 59 + ($authorizations == null ? 43 : ((Object)$authorizations).hashCode());
        List<PisPaymentData> $payments = this.getPayments();
        result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
        OffsetDateTime $creationTimestamp = this.getCreationTimestamp();
        result = result * 59 + ($creationTimestamp == null ? 43 : ((Object)$creationTimestamp).hashCode());
        String $aspspAccountId = this.getAspspAccountId();
        result = result * 59 + ($aspspAccountId == null ? 43 : $aspspAccountId.hashCode());
        return result;
    }

    public String toString() {
        return "PisCommonPaymentData(id=" + this.getId() + ", paymentId=" + this.getPaymentId() + ", paymentType=" + this.getPaymentType() + ", paymentProduct=" + this.getPaymentProduct() + ", transactionStatus=" + this.getTransactionStatus() + ", payment=" + Arrays.toString(this.getPayment()) + ", psuData=" + this.getPsuData() + ", tppInfo=" + this.getTppInfo() + ", authorizations=" + this.getAuthorizations() + ", payments=" + this.getPayments() + ", creationTimestamp=" + this.getCreationTimestamp() + ", aspspAccountId=" + this.getAspspAccountId() + ")";
    }
}

