/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain.payment;

import de.adorsys.psd2.consent.api.CmsAuthorisationType;
import de.adorsys.psd2.consent.domain.InstanceDependableEntity;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.time.OffsetDateTime;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;

@Entity(name="pis_consent_authorization")
public class PisAuthorization
extends InstanceDependableEntity {
    @Id
    @Column(name="authorization_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="pis_consent_authorization_generator")
    @SequenceGenerator(name="pis_consent_authorization_generator", sequenceName="pis_consent_auth_id_seq")
    private Long id;
    @Column(name="external_id", nullable=false)
    private String externalId;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="psu_id")
    private PsuData psuData;
    @Column(name="sca_status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private ScaStatus scaStatus;
    @Column(name="chosen_sca_method")
    private String chosenScaMethod;
    @Column(name="authorization_type")
    @Enumerated(value=EnumType.STRING)
    private CmsAuthorisationType authorizationType;
    @Column(name="expiration_timestamp")
    private OffsetDateTime redirectUrlExpirationTimestamp;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="payment_id", nullable=false)
    private PisCommonPaymentData paymentData;

    public boolean isExpired() {
        return !this.isNotExpired();
    }

    public boolean isNotExpired() {
        return this.redirectUrlExpirationTimestamp.isAfter(OffsetDateTime.now());
    }

    public Long getId() {
        return this.id;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public PsuData getPsuData() {
        return this.psuData;
    }

    public ScaStatus getScaStatus() {
        return this.scaStatus;
    }

    public String getChosenScaMethod() {
        return this.chosenScaMethod;
    }

    public CmsAuthorisationType getAuthorizationType() {
        return this.authorizationType;
    }

    public OffsetDateTime getRedirectUrlExpirationTimestamp() {
        return this.redirectUrlExpirationTimestamp;
    }

    public PisCommonPaymentData getPaymentData() {
        return this.paymentData;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setPsuData(PsuData psuData) {
        this.psuData = psuData;
    }

    public void setScaStatus(ScaStatus scaStatus) {
        this.scaStatus = scaStatus;
    }

    public void setChosenScaMethod(String chosenScaMethod) {
        this.chosenScaMethod = chosenScaMethod;
    }

    public void setAuthorizationType(CmsAuthorisationType authorizationType) {
        this.authorizationType = authorizationType;
    }

    public void setRedirectUrlExpirationTimestamp(OffsetDateTime redirectUrlExpirationTimestamp) {
        this.redirectUrlExpirationTimestamp = redirectUrlExpirationTimestamp;
    }

    public void setPaymentData(PisCommonPaymentData paymentData) {
        this.paymentData = paymentData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PisAuthorization)) {
            return false;
        }
        PisAuthorization other = (PisAuthorization)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        PsuData this$psuData = this.getPsuData();
        PsuData other$psuData = other.getPsuData();
        if (this$psuData == null ? other$psuData != null : !((Object)this$psuData).equals(other$psuData)) {
            return false;
        }
        ScaStatus this$scaStatus = this.getScaStatus();
        ScaStatus other$scaStatus = other.getScaStatus();
        if (this$scaStatus == null ? other$scaStatus != null : !this$scaStatus.equals(other$scaStatus)) {
            return false;
        }
        String this$chosenScaMethod = this.getChosenScaMethod();
        String other$chosenScaMethod = other.getChosenScaMethod();
        if (this$chosenScaMethod == null ? other$chosenScaMethod != null : !this$chosenScaMethod.equals(other$chosenScaMethod)) {
            return false;
        }
        CmsAuthorisationType this$authorizationType = this.getAuthorizationType();
        CmsAuthorisationType other$authorizationType = other.getAuthorizationType();
        if (this$authorizationType == null ? other$authorizationType != null : !this$authorizationType.equals(other$authorizationType)) {
            return false;
        }
        OffsetDateTime this$redirectUrlExpirationTimestamp = this.getRedirectUrlExpirationTimestamp();
        OffsetDateTime other$redirectUrlExpirationTimestamp = other.getRedirectUrlExpirationTimestamp();
        if (this$redirectUrlExpirationTimestamp == null ? other$redirectUrlExpirationTimestamp != null : !((Object)this$redirectUrlExpirationTimestamp).equals(other$redirectUrlExpirationTimestamp)) {
            return false;
        }
        PisCommonPaymentData this$paymentData = this.getPaymentData();
        PisCommonPaymentData other$paymentData = other.getPaymentData();
        return !(this$paymentData == null ? other$paymentData != null : !((Object)this$paymentData).equals(other$paymentData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PisAuthorization;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        PsuData $psuData = this.getPsuData();
        result = result * 59 + ($psuData == null ? 43 : ((Object)$psuData).hashCode());
        ScaStatus $scaStatus = this.getScaStatus();
        result = result * 59 + ($scaStatus == null ? 43 : $scaStatus.hashCode());
        String $chosenScaMethod = this.getChosenScaMethod();
        result = result * 59 + ($chosenScaMethod == null ? 43 : $chosenScaMethod.hashCode());
        CmsAuthorisationType $authorizationType = this.getAuthorizationType();
        result = result * 59 + ($authorizationType == null ? 43 : $authorizationType.hashCode());
        OffsetDateTime $redirectUrlExpirationTimestamp = this.getRedirectUrlExpirationTimestamp();
        result = result * 59 + ($redirectUrlExpirationTimestamp == null ? 43 : ((Object)$redirectUrlExpirationTimestamp).hashCode());
        PisCommonPaymentData $paymentData = this.getPaymentData();
        result = result * 59 + ($paymentData == null ? 43 : ((Object)$paymentData).hashCode());
        return result;
    }

    public String toString() {
        return "PisAuthorization(id=" + this.getId() + ", externalId=" + this.getExternalId() + ", psuData=" + this.getPsuData() + ", scaStatus=" + this.getScaStatus() + ", chosenScaMethod=" + this.getChosenScaMethod() + ", authorizationType=" + this.getAuthorizationType() + ", redirectUrlExpirationTimestamp=" + this.getRedirectUrlExpirationTimestamp() + ")";
    }
}

