/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.api.pis;

import de.adorsys.psd2.consent.api.pis.CommonPaymentData;
import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@ApiModel(description="Pis payment initialisation common payment response", value="PisCommonPaymentResponse")
public class PisCommonPaymentResponse
implements CommonPaymentData {
    @ApiModelProperty(value="Payment data", required=true)
    private List<PisPayment> payments;
    @ApiModelProperty(value="Payment product", required=true, example="sepa-credit-transfers")
    private String paymentProduct;
    @ApiModelProperty(value="Payment type: BULK, SINGLE or PERIODIC.", required=true, example="SINGLE")
    private PaymentType paymentType;
    @ApiModelProperty(value="Tpp information", required=true)
    private TppInfo tppInfo;
    @ApiModelProperty(value="An external exposed identification of the created common payment", required=true, example="bf489af6-a2cb-4b75-b71d-d66d58b934d7")
    private String externalId;
    @ApiModelProperty(value="List of corresponding PSU", required=true)
    private List<PsuIdData> psuData;
    @ApiModelProperty(value="Payment info")
    private byte[] paymentData;
    @ApiModelProperty(value="Transaction status", required=true)
    private TransactionStatus transactionStatus;
    @ApiModelProperty(value="Timestamp of the last payment transaction status changing")
    private OffsetDateTime statusChangeTimestamp;
    @ApiModelProperty(value="List of corresponding PSU", required=true)
    private List<Authorisation> authorisations = new ArrayList<Authorisation>();
    @ApiModelProperty(value="Defines whether the payment requires multilevel SCA", example="true")
    private boolean multilevelScaRequired;
    @ApiModelProperty(value="Timestamp of the payment creation")
    private OffsetDateTime creationTimestamp;
    @ApiModelProperty(value="Response content type")
    private String contentType;
    @ApiModelProperty(value="Response instance id")
    private String instanceId;
    @ApiModelProperty(value="Signing basket blocked")
    private boolean signingBasketBlocked;
    @ApiModelProperty(value="Signing basket authorised")
    private boolean signingBasketAuthorised;

    public Optional<Authorisation> findAuthorisationInPayment(String authorisationId) {
        return this.authorisations.stream().filter(auth -> auth.getAuthorisationId().equals(authorisationId)).findFirst();
    }

    @Override
    public List<PisPayment> getPayments() {
        return this.payments;
    }

    @Override
    public String getPaymentProduct() {
        return this.paymentProduct;
    }

    @Override
    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public TppInfo getTppInfo() {
        return this.tppInfo;
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public List<PsuIdData> getPsuData() {
        return this.psuData;
    }

    @Override
    public byte[] getPaymentData() {
        return this.paymentData;
    }

    @Override
    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    @Override
    public OffsetDateTime getStatusChangeTimestamp() {
        return this.statusChangeTimestamp;
    }

    public List<Authorisation> getAuthorisations() {
        return this.authorisations;
    }

    public boolean isMultilevelScaRequired() {
        return this.multilevelScaRequired;
    }

    @Override
    public OffsetDateTime getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    public boolean isSigningBasketBlocked() {
        return this.signingBasketBlocked;
    }

    public boolean isSigningBasketAuthorised() {
        return this.signingBasketAuthorised;
    }

    public void setPayments(List<PisPayment> payments) {
        this.payments = payments;
    }

    public void setPaymentProduct(String paymentProduct) {
        this.paymentProduct = paymentProduct;
    }

    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    public void setTppInfo(TppInfo tppInfo) {
        this.tppInfo = tppInfo;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setPsuData(List<PsuIdData> psuData) {
        this.psuData = psuData;
    }

    public void setPaymentData(byte[] paymentData) {
        this.paymentData = paymentData;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public void setStatusChangeTimestamp(OffsetDateTime statusChangeTimestamp) {
        this.statusChangeTimestamp = statusChangeTimestamp;
    }

    public void setAuthorisations(List<Authorisation> authorisations) {
        this.authorisations = authorisations;
    }

    public void setMultilevelScaRequired(boolean multilevelScaRequired) {
        this.multilevelScaRequired = multilevelScaRequired;
    }

    public void setCreationTimestamp(OffsetDateTime creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setSigningBasketBlocked(boolean signingBasketBlocked) {
        this.signingBasketBlocked = signingBasketBlocked;
    }

    public void setSigningBasketAuthorised(boolean signingBasketAuthorised) {
        this.signingBasketAuthorised = signingBasketAuthorised;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PisCommonPaymentResponse)) {
            return false;
        }
        PisCommonPaymentResponse other = (PisCommonPaymentResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<PisPayment> this$payments = this.getPayments();
        List<PisPayment> other$payments = other.getPayments();
        if (this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments)) {
            return false;
        }
        String this$paymentProduct = this.getPaymentProduct();
        String other$paymentProduct = other.getPaymentProduct();
        if (this$paymentProduct == null ? other$paymentProduct != null : !this$paymentProduct.equals(other$paymentProduct)) {
            return false;
        }
        PaymentType this$paymentType = this.getPaymentType();
        PaymentType other$paymentType = other.getPaymentType();
        if (this$paymentType == null ? other$paymentType != null : !this$paymentType.equals(other$paymentType)) {
            return false;
        }
        TppInfo this$tppInfo = this.getTppInfo();
        TppInfo other$tppInfo = other.getTppInfo();
        if (this$tppInfo == null ? other$tppInfo != null : !this$tppInfo.equals(other$tppInfo)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        List<PsuIdData> this$psuData = this.getPsuData();
        List<PsuIdData> other$psuData = other.getPsuData();
        if (this$psuData == null ? other$psuData != null : !((Object)this$psuData).equals(other$psuData)) {
            return false;
        }
        if (!Arrays.equals(this.getPaymentData(), other.getPaymentData())) {
            return false;
        }
        TransactionStatus this$transactionStatus = this.getTransactionStatus();
        TransactionStatus other$transactionStatus = other.getTransactionStatus();
        if (this$transactionStatus == null ? other$transactionStatus != null : !this$transactionStatus.equals(other$transactionStatus)) {
            return false;
        }
        OffsetDateTime this$statusChangeTimestamp = this.getStatusChangeTimestamp();
        OffsetDateTime other$statusChangeTimestamp = other.getStatusChangeTimestamp();
        if (this$statusChangeTimestamp == null ? other$statusChangeTimestamp != null : !((Object)this$statusChangeTimestamp).equals(other$statusChangeTimestamp)) {
            return false;
        }
        List<Authorisation> this$authorisations = this.getAuthorisations();
        List<Authorisation> other$authorisations = other.getAuthorisations();
        if (this$authorisations == null ? other$authorisations != null : !((Object)this$authorisations).equals(other$authorisations)) {
            return false;
        }
        if (this.isMultilevelScaRequired() != other.isMultilevelScaRequired()) {
            return false;
        }
        OffsetDateTime this$creationTimestamp = this.getCreationTimestamp();
        OffsetDateTime other$creationTimestamp = other.getCreationTimestamp();
        if (this$creationTimestamp == null ? other$creationTimestamp != null : !((Object)this$creationTimestamp).equals(other$creationTimestamp)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        String this$instanceId = this.getInstanceId();
        String other$instanceId = other.getInstanceId();
        if (this$instanceId == null ? other$instanceId != null : !this$instanceId.equals(other$instanceId)) {
            return false;
        }
        if (this.isSigningBasketBlocked() != other.isSigningBasketBlocked()) {
            return false;
        }
        return this.isSigningBasketAuthorised() == other.isSigningBasketAuthorised();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PisCommonPaymentResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<PisPayment> $payments = this.getPayments();
        result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
        String $paymentProduct = this.getPaymentProduct();
        result = result * 59 + ($paymentProduct == null ? 43 : $paymentProduct.hashCode());
        PaymentType $paymentType = this.getPaymentType();
        result = result * 59 + ($paymentType == null ? 43 : $paymentType.hashCode());
        TppInfo $tppInfo = this.getTppInfo();
        result = result * 59 + ($tppInfo == null ? 43 : $tppInfo.hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        List<PsuIdData> $psuData = this.getPsuData();
        result = result * 59 + ($psuData == null ? 43 : ((Object)$psuData).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPaymentData());
        TransactionStatus $transactionStatus = this.getTransactionStatus();
        result = result * 59 + ($transactionStatus == null ? 43 : $transactionStatus.hashCode());
        OffsetDateTime $statusChangeTimestamp = this.getStatusChangeTimestamp();
        result = result * 59 + ($statusChangeTimestamp == null ? 43 : ((Object)$statusChangeTimestamp).hashCode());
        List<Authorisation> $authorisations = this.getAuthorisations();
        result = result * 59 + ($authorisations == null ? 43 : ((Object)$authorisations).hashCode());
        result = result * 59 + (this.isMultilevelScaRequired() ? 79 : 97);
        OffsetDateTime $creationTimestamp = this.getCreationTimestamp();
        result = result * 59 + ($creationTimestamp == null ? 43 : ((Object)$creationTimestamp).hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        String $instanceId = this.getInstanceId();
        result = result * 59 + ($instanceId == null ? 43 : $instanceId.hashCode());
        result = result * 59 + (this.isSigningBasketBlocked() ? 79 : 97);
        result = result * 59 + (this.isSigningBasketAuthorised() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "PisCommonPaymentResponse(payments=" + this.getPayments() + ", paymentProduct=" + this.getPaymentProduct() + ", paymentType=" + this.getPaymentType() + ", tppInfo=" + this.getTppInfo() + ", externalId=" + this.getExternalId() + ", psuData=" + this.getPsuData() + ", paymentData=" + Arrays.toString(this.getPaymentData()) + ", transactionStatus=" + this.getTransactionStatus() + ", statusChangeTimestamp=" + this.getStatusChangeTimestamp() + ", authorisations=" + this.getAuthorisations() + ", multilevelScaRequired=" + this.isMultilevelScaRequired() + ", creationTimestamp=" + this.getCreationTimestamp() + ", contentType=" + this.getContentType() + ", instanceId=" + this.getInstanceId() + ", signingBasketBlocked=" + this.isSigningBasketBlocked() + ", signingBasketAuthorised=" + this.isSigningBasketAuthorised() + ")";
    }
}

