/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.api.ais;

import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public enum AdditionalAccountInformationType {
    DEDICATED_ACCOUNTS{

        @Override
        public List<AccountReference> getReferencesByType(List<AccountReference> accountReferences) {
            return accountReferences;
        }
    }
    ,
    ALL_AVAILABLE_ACCOUNTS{

        @Override
        public List<AccountReference> getReferencesByType(List<AccountReference> accountReferences) {
            return Collections.emptyList();
        }
    }
    ,
    NONE{

        @Override
        public List<AccountReference> getReferencesByType(List<AccountReference> accountReferences) {
            return null;
        }
    };


    public static AdditionalAccountInformationType findTypeByList(List<?> list) {
        return Optional.ofNullable(list).map(l -> l.isEmpty() ? ALL_AVAILABLE_ACCOUNTS : DEDICATED_ACCOUNTS).orElse(NONE);
    }

    public abstract List<AccountReference> getReferencesByType(List<AccountReference> var1);
}

