/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.api.ais;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.profile.AdditionalInformationAccess;
import java.beans.ConstructorProperties;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public final class AisAccountAccess {
    private final List<AccountReference> accounts;
    private final List<AccountReference> balances;
    private final List<AccountReference> transactions;
    private final String availableAccounts;
    private final String allPsd2;
    private final String availableAccountsWithBalance;
    private final AdditionalInformationAccess accountAdditionalInformationAccess;

    @JsonIgnore
    public boolean isNotEmpty() {
        return !CollectionUtils.isEmpty(this.accounts) || !CollectionUtils.isEmpty(this.balances) || !CollectionUtils.isEmpty(this.transactions) || this.allPsd2 != null || this.availableAccounts != null || this.availableAccountsWithBalance != null;
    }

    @ConstructorProperties(value={"accounts", "balances", "transactions", "availableAccounts", "allPsd2", "availableAccountsWithBalance", "accountAdditionalInformationAccess"})
    public AisAccountAccess(List<AccountReference> accounts, List<AccountReference> balances, List<AccountReference> transactions, String availableAccounts, String allPsd2, String availableAccountsWithBalance, AdditionalInformationAccess accountAdditionalInformationAccess) {
        this.accounts = accounts;
        this.balances = balances;
        this.transactions = transactions;
        this.availableAccounts = availableAccounts;
        this.allPsd2 = allPsd2;
        this.availableAccountsWithBalance = availableAccountsWithBalance;
        this.accountAdditionalInformationAccess = accountAdditionalInformationAccess;
    }

    public List<AccountReference> getAccounts() {
        return this.accounts;
    }

    public List<AccountReference> getBalances() {
        return this.balances;
    }

    public List<AccountReference> getTransactions() {
        return this.transactions;
    }

    public String getAvailableAccounts() {
        return this.availableAccounts;
    }

    public String getAllPsd2() {
        return this.allPsd2;
    }

    public String getAvailableAccountsWithBalance() {
        return this.availableAccountsWithBalance;
    }

    public AdditionalInformationAccess getAccountAdditionalInformationAccess() {
        return this.accountAdditionalInformationAccess;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AisAccountAccess)) {
            return false;
        }
        AisAccountAccess other = (AisAccountAccess)o;
        List<AccountReference> this$accounts = this.getAccounts();
        List<AccountReference> other$accounts = other.getAccounts();
        if (this$accounts == null ? other$accounts != null : !((Object)this$accounts).equals(other$accounts)) {
            return false;
        }
        List<AccountReference> this$balances = this.getBalances();
        List<AccountReference> other$balances = other.getBalances();
        if (this$balances == null ? other$balances != null : !((Object)this$balances).equals(other$balances)) {
            return false;
        }
        List<AccountReference> this$transactions = this.getTransactions();
        List<AccountReference> other$transactions = other.getTransactions();
        if (this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions)) {
            return false;
        }
        String this$availableAccounts = this.getAvailableAccounts();
        String other$availableAccounts = other.getAvailableAccounts();
        if (this$availableAccounts == null ? other$availableAccounts != null : !this$availableAccounts.equals(other$availableAccounts)) {
            return false;
        }
        String this$allPsd2 = this.getAllPsd2();
        String other$allPsd2 = other.getAllPsd2();
        if (this$allPsd2 == null ? other$allPsd2 != null : !this$allPsd2.equals(other$allPsd2)) {
            return false;
        }
        String this$availableAccountsWithBalance = this.getAvailableAccountsWithBalance();
        String other$availableAccountsWithBalance = other.getAvailableAccountsWithBalance();
        if (this$availableAccountsWithBalance == null ? other$availableAccountsWithBalance != null : !this$availableAccountsWithBalance.equals(other$availableAccountsWithBalance)) {
            return false;
        }
        AdditionalInformationAccess this$accountAdditionalInformationAccess = this.getAccountAdditionalInformationAccess();
        AdditionalInformationAccess other$accountAdditionalInformationAccess = other.getAccountAdditionalInformationAccess();
        return !(this$accountAdditionalInformationAccess == null ? other$accountAdditionalInformationAccess != null : !this$accountAdditionalInformationAccess.equals(other$accountAdditionalInformationAccess));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<AccountReference> $accounts = this.getAccounts();
        result = result * 59 + ($accounts == null ? 43 : ((Object)$accounts).hashCode());
        List<AccountReference> $balances = this.getBalances();
        result = result * 59 + ($balances == null ? 43 : ((Object)$balances).hashCode());
        List<AccountReference> $transactions = this.getTransactions();
        result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
        String $availableAccounts = this.getAvailableAccounts();
        result = result * 59 + ($availableAccounts == null ? 43 : $availableAccounts.hashCode());
        String $allPsd2 = this.getAllPsd2();
        result = result * 59 + ($allPsd2 == null ? 43 : $allPsd2.hashCode());
        String $availableAccountsWithBalance = this.getAvailableAccountsWithBalance();
        result = result * 59 + ($availableAccountsWithBalance == null ? 43 : $availableAccountsWithBalance.hashCode());
        AdditionalInformationAccess $accountAdditionalInformationAccess = this.getAccountAdditionalInformationAccess();
        result = result * 59 + ($accountAdditionalInformationAccess == null ? 43 : $accountAdditionalInformationAccess.hashCode());
        return result;
    }

    public String toString() {
        return "AisAccountAccess(accounts=" + this.getAccounts() + ", balances=" + this.getBalances() + ", transactions=" + this.getTransactions() + ", availableAccounts=" + this.getAvailableAccounts() + ", allPsd2=" + this.getAllPsd2() + ", availableAccountsWithBalance=" + this.getAvailableAccountsWithBalance() + ", accountAdditionalInformationAccess=" + this.getAccountAdditionalInformationAccess() + ")";
    }
}

