/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.api.pis;

import de.adorsys.psd2.consent.api.pis.CmsPaymentResponse;
import java.beans.ConstructorProperties;
import java.util.Optional;

public final class CmsPaymentIdentifier {
    private final String paymentId;
    private final String authorisationId;
    private final String tppOkRedirectUri;
    private final String tppNokRedirectUri;

    public CmsPaymentIdentifier(CmsPaymentResponse cmsPaymentResponse) {
        this.paymentId = cmsPaymentResponse.getPayment().getPaymentId();
        this.authorisationId = cmsPaymentResponse.getAuthorisationId();
        this.tppOkRedirectUri = Optional.ofNullable(cmsPaymentResponse.getTppOkRedirectUri()).orElse(null);
        this.tppNokRedirectUri = Optional.ofNullable(cmsPaymentResponse.getTppNokRedirectUri()).orElse(null);
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public String getAuthorisationId() {
        return this.authorisationId;
    }

    public String getTppOkRedirectUri() {
        return this.tppOkRedirectUri;
    }

    public String getTppNokRedirectUri() {
        return this.tppNokRedirectUri;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CmsPaymentIdentifier)) {
            return false;
        }
        CmsPaymentIdentifier other = (CmsPaymentIdentifier)o;
        String this$paymentId = this.getPaymentId();
        String other$paymentId = other.getPaymentId();
        if (this$paymentId == null ? other$paymentId != null : !this$paymentId.equals(other$paymentId)) {
            return false;
        }
        String this$authorisationId = this.getAuthorisationId();
        String other$authorisationId = other.getAuthorisationId();
        if (this$authorisationId == null ? other$authorisationId != null : !this$authorisationId.equals(other$authorisationId)) {
            return false;
        }
        String this$tppOkRedirectUri = this.getTppOkRedirectUri();
        String other$tppOkRedirectUri = other.getTppOkRedirectUri();
        if (this$tppOkRedirectUri == null ? other$tppOkRedirectUri != null : !this$tppOkRedirectUri.equals(other$tppOkRedirectUri)) {
            return false;
        }
        String this$tppNokRedirectUri = this.getTppNokRedirectUri();
        String other$tppNokRedirectUri = other.getTppNokRedirectUri();
        return !(this$tppNokRedirectUri == null ? other$tppNokRedirectUri != null : !this$tppNokRedirectUri.equals(other$tppNokRedirectUri));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $paymentId = this.getPaymentId();
        result = result * 59 + ($paymentId == null ? 43 : $paymentId.hashCode());
        String $authorisationId = this.getAuthorisationId();
        result = result * 59 + ($authorisationId == null ? 43 : $authorisationId.hashCode());
        String $tppOkRedirectUri = this.getTppOkRedirectUri();
        result = result * 59 + ($tppOkRedirectUri == null ? 43 : $tppOkRedirectUri.hashCode());
        String $tppNokRedirectUri = this.getTppNokRedirectUri();
        result = result * 59 + ($tppNokRedirectUri == null ? 43 : $tppNokRedirectUri.hashCode());
        return result;
    }

    public String toString() {
        return "CmsPaymentIdentifier(paymentId=" + this.getPaymentId() + ", authorisationId=" + this.getAuthorisationId() + ", tppOkRedirectUri=" + this.getTppOkRedirectUri() + ", tppNokRedirectUri=" + this.getTppNokRedirectUri() + ")";
    }

    @ConstructorProperties(value={"paymentId", "authorisationId", "tppOkRedirectUri", "tppNokRedirectUri"})
    public CmsPaymentIdentifier(String paymentId, String authorisationId, String tppOkRedirectUri, String tppNokRedirectUri) {
        this.paymentId = paymentId;
        this.authorisationId = authorisationId;
        this.tppOkRedirectUri = tppOkRedirectUri;
        this.tppNokRedirectUri = tppNokRedirectUri;
    }
}

