/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.api.ais;

import de.adorsys.psd2.consent.api.ais.CmsAisConsentResponse;
import java.beans.ConstructorProperties;
import java.util.Optional;

public final class CmsConsentIdentifier {
    private final String consentId;
    private final String authorisationId;
    private final String tppOkRedirectUri;
    private final String tppNokRedirectUri;

    public CmsConsentIdentifier(CmsAisConsentResponse cmsAisConsentResponse) {
        this.consentId = cmsAisConsentResponse.getAccountConsent().getId();
        this.authorisationId = cmsAisConsentResponse.getAuthorisationId();
        this.tppOkRedirectUri = Optional.ofNullable(cmsAisConsentResponse.getTppOkRedirectUri()).orElse(null);
        this.tppNokRedirectUri = Optional.ofNullable(cmsAisConsentResponse.getTppNokRedirectUri()).orElse(null);
    }

    public String getConsentId() {
        return this.consentId;
    }

    public String getAuthorisationId() {
        return this.authorisationId;
    }

    public String getTppOkRedirectUri() {
        return this.tppOkRedirectUri;
    }

    public String getTppNokRedirectUri() {
        return this.tppNokRedirectUri;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CmsConsentIdentifier)) {
            return false;
        }
        CmsConsentIdentifier other = (CmsConsentIdentifier)o;
        String this$consentId = this.getConsentId();
        String other$consentId = other.getConsentId();
        if (this$consentId == null ? other$consentId != null : !this$consentId.equals(other$consentId)) {
            return false;
        }
        String this$authorisationId = this.getAuthorisationId();
        String other$authorisationId = other.getAuthorisationId();
        if (this$authorisationId == null ? other$authorisationId != null : !this$authorisationId.equals(other$authorisationId)) {
            return false;
        }
        String this$tppOkRedirectUri = this.getTppOkRedirectUri();
        String other$tppOkRedirectUri = other.getTppOkRedirectUri();
        if (this$tppOkRedirectUri == null ? other$tppOkRedirectUri != null : !this$tppOkRedirectUri.equals(other$tppOkRedirectUri)) {
            return false;
        }
        String this$tppNokRedirectUri = this.getTppNokRedirectUri();
        String other$tppNokRedirectUri = other.getTppNokRedirectUri();
        return !(this$tppNokRedirectUri == null ? other$tppNokRedirectUri != null : !this$tppNokRedirectUri.equals(other$tppNokRedirectUri));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $consentId = this.getConsentId();
        result = result * 59 + ($consentId == null ? 43 : $consentId.hashCode());
        String $authorisationId = this.getAuthorisationId();
        result = result * 59 + ($authorisationId == null ? 43 : $authorisationId.hashCode());
        String $tppOkRedirectUri = this.getTppOkRedirectUri();
        result = result * 59 + ($tppOkRedirectUri == null ? 43 : $tppOkRedirectUri.hashCode());
        String $tppNokRedirectUri = this.getTppNokRedirectUri();
        result = result * 59 + ($tppNokRedirectUri == null ? 43 : $tppNokRedirectUri.hashCode());
        return result;
    }

    public String toString() {
        return "CmsConsentIdentifier(consentId=" + this.getConsentId() + ", authorisationId=" + this.getAuthorisationId() + ", tppOkRedirectUri=" + this.getTppOkRedirectUri() + ", tppNokRedirectUri=" + this.getTppNokRedirectUri() + ")";
    }

    @ConstructorProperties(value={"consentId", "authorisationId", "tppOkRedirectUri", "tppNokRedirectUri"})
    public CmsConsentIdentifier(String consentId, String authorisationId, String tppOkRedirectUri, String tppNokRedirectUri) {
        this.consentId = consentId;
        this.authorisationId = authorisationId;
        this.tppOkRedirectUri = tppOkRedirectUri;
        this.tppNokRedirectUri = tppNokRedirectUri;
    }
}

