/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.aspsp.controller;

import de.adorsys.psd2.consent.aspsp.api.CmsAspspStopListApi;
import de.adorsys.psd2.consent.aspsp.api.tpp.CmsAspspTppService;
import de.adorsys.psd2.xs2a.core.tpp.TppStopListRecord;
import java.beans.ConstructorProperties;
import java.time.Duration;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CmsAspspStopListController
implements CmsAspspStopListApi {
    private final CmsAspspTppService cmsAspspTppService;

    public ResponseEntity<TppStopListRecord> getTppStopListRecord(String tppAuthorisationNumber, String instanceId) {
        return this.cmsAspspTppService.getTppStopListRecord(tppAuthorisationNumber, instanceId).map(record -> new ResponseEntity(record, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    public ResponseEntity<Boolean> blockTpp(String tppAuthorisationNumber, String instanceId, Long lockPeriod) {
        Duration lockPeriodDuration = lockPeriod != null ? Duration.ofMillis(lockPeriod) : null;
        boolean isBlocked = this.cmsAspspTppService.blockTpp(tppAuthorisationNumber, instanceId, lockPeriodDuration);
        return new ResponseEntity((Object)isBlocked, HttpStatus.OK);
    }

    public ResponseEntity<Boolean> unblockTpp(String tppAuthorisationNumber, String instanceId) {
        boolean isUnblocked = this.cmsAspspTppService.unblockTpp(tppAuthorisationNumber, instanceId);
        return new ResponseEntity((Object)isUnblocked, HttpStatus.OK);
    }

    @ConstructorProperties(value={"cmsAspspTppService"})
    public CmsAspspStopListController(CmsAspspTppService cmsAspspTppService) {
        this.cmsAspspTppService = cmsAspspTppService;
    }
}

