/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.aspsp.controller;

import de.adorsys.psd2.consent.api.piis.v1.CmsPiisConsent;
import de.adorsys.psd2.consent.aspsp.api.CmsAspspPiisApi;
import de.adorsys.psd2.consent.aspsp.api.piis.CmsAspspPiisService;
import de.adorsys.psd2.consent.aspsp.api.piis.CreatePiisConsentRequest;
import de.adorsys.psd2.consent.aspsp.api.piis.CreatePiisConsentResponse;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CmsAspspPiisController
implements CmsAspspPiisApi {
    private final CmsAspspPiisService cmsAspspPiisService;

    public ResponseEntity<CreatePiisConsentResponse> createConsent(CreatePiisConsentRequest request, String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, String instanceId) {
        PsuIdData psuIdData = this.getPsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        return this.cmsAspspPiisService.createConsent(psuIdData, request, instanceId).map(consentId -> new ResponseEntity((Object)new CreatePiisConsentResponse(consentId), HttpStatus.CREATED)).orElseGet(() -> new ResponseEntity(HttpStatus.BAD_REQUEST));
    }

    public ResponseEntity<List<CmsPiisConsent>> getConsentsForPsu(String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, String instanceId) {
        PsuIdData psuIdData = this.getPsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        return new ResponseEntity((Object)this.cmsAspspPiisService.getConsentsForPsu(psuIdData, instanceId), HttpStatus.OK);
    }

    public ResponseEntity<Boolean> terminateConsent(String consentId, String instanceId) {
        return new ResponseEntity((Object)this.cmsAspspPiisService.terminateConsent(consentId, instanceId), HttpStatus.OK);
    }

    private PsuIdData getPsuIdData(String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType) {
        return new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType, null);
    }

    @ConstructorProperties(value={"cmsAspspPiisService"})
    public CmsAspspPiisController(CmsAspspPiisService cmsAspspPiisService) {
        this.cmsAspspPiisService = cmsAspspPiisService;
    }
}

