/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.aspsp.controller;

import de.adorsys.psd2.consent.api.piis.CmsPiisConsent;
import de.adorsys.psd2.consent.aspsp.api.CmsAspspPiisExportApi;
import de.adorsys.psd2.consent.aspsp.api.piis.CmsAspspPiisFundsExportService;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collection;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CmsAspspPiisExportController
implements CmsAspspPiisExportApi {
    private final CmsAspspPiisFundsExportService cmsAspspPiisExportService;

    public ResponseEntity<Collection<CmsPiisConsent>> getConsentsByTpp(String tppId, LocalDate start, LocalDate end, String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, String instanceId) {
        PsuIdData psuIdData = new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType, null);
        Collection consents = this.cmsAspspPiisExportService.exportConsentsByTpp(tppId, start, end, psuIdData, instanceId);
        return new ResponseEntity((Object)consents, HttpStatus.OK);
    }

    public ResponseEntity<Collection<CmsPiisConsent>> getConsentsByPsu(LocalDate start, LocalDate end, String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, String instanceId) {
        PsuIdData psuIdData = new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType, null);
        Collection consents = this.cmsAspspPiisExportService.exportConsentsByPsu(psuIdData, start, end, instanceId);
        return new ResponseEntity((Object)consents, HttpStatus.OK);
    }

    public ResponseEntity<Collection<CmsPiisConsent>> getConsentsByAccountId(String aspspAccountId, LocalDate start, LocalDate end, String instanceId) {
        Collection consents = this.cmsAspspPiisExportService.exportConsentsByAccountId(aspspAccountId, start, end, instanceId);
        return new ResponseEntity((Object)consents, HttpStatus.OK);
    }

    @ConstructorProperties(value={"cmsAspspPiisExportService"})
    public CmsAspspPiisExportController(CmsAspspPiisFundsExportService cmsAspspPiisExportService) {
        this.cmsAspspPiisExportService = cmsAspspPiisExportService;
    }
}

