/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.aspsp.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.beans.ConstructorProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.info.BuildProperties;
import org.springframework.context.annotation.Bean;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
public class AspspApiSwaggerConfig {
    @Value(value="${license.url}")
    private String licenseUrl;
    private final BuildProperties buildProperties;

    @Bean(name={"aspsp-api"})
    public Docket apiDocklet() {
        return new Docket(DocumentationType.SWAGGER_2).groupName("CMS-ASPSP-API").apiInfo(this.getApiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)"de.adorsys.psd2.consent.web.aspsp")).paths(Predicates.not((Predicate)PathSelectors.regex((String)"/error.*?"))).paths(Predicates.not((Predicate)PathSelectors.regex((String)"/connect.*"))).paths(Predicates.not((Predicate)PathSelectors.regex((String)"/management.*"))).build();
    }

    private ApiInfo getApiInfo() {
        return new ApiInfoBuilder().title("XS2A CMS ASPSP REST API").contact(new Contact("adorsys GmbH & Co. KG", "https://adorsys.de/en/psd2", "psd2@adorsys.de")).version(this.buildProperties.getVersion() + " " + this.buildProperties.get("build.number")).license("Apache License 2.0").licenseUrl(this.licenseUrl).build();
    }

    @ConstructorProperties(value={"buildProperties"})
    public AspspApiSwaggerConfig(BuildProperties buildProperties) {
        this.buildProperties = buildProperties;
    }
}

