/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.aspsp.controller;

import de.adorsys.psd2.event.service.AspspEventService;
import de.adorsys.psd2.event.service.model.AspspEvent;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.util.List;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"aspsp-api/v1/events"})
@Api(value="aspsp-api/v1/events", tags={"ASPSP Events"}, description="Provides access to the consent management system for ASPSP Events")
public class CmsAspspEventController {
    private final AspspEventService aspspEventService;

    @GetMapping(path={"/"})
    @ApiOperation(value="Returns a list of Event objects between two dates")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public ResponseEntity<List<AspspEvent>> getEventsForDates(@ApiParam(value="Start date", example="2010-01-01T00:00:00Z", required=true) @RequestHeader(value="start-date") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime start, @ApiParam(value="End date", example="2030-01-01T00:00:00Z", required=true) @RequestHeader(value="end-date") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime end, @ApiParam(value="Bank instance ID") @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String instanceId) {
        List events = this.aspspEventService.getEventsForPeriod(start, end, instanceId);
        return new ResponseEntity((Object)events, HttpStatus.OK);
    }

    @ConstructorProperties(value={"aspspEventService"})
    public CmsAspspEventController(AspspEventService aspspEventService) {
        this.aspspEventService = aspspEventService;
    }
}

