/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.aspsp.controller;

import de.adorsys.psd2.consent.aspsp.api.tpp.CmsAspspTppService;
import de.adorsys.psd2.xs2a.core.tpp.TppStopListRecord;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.time.Duration;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"aspsp-api/v1/tpp/stop-list"})
@Api(value="aspsp-api/v1/tpp/stop-list", tags={"ASPSP TPP Stop List"}, description="Provides access to the consent management system TPP Stop List")
public class CmsAspspStopListController {
    private final CmsAspspTppService cmsAspspTppService;

    @GetMapping
    @ApiOperation(value="Returns TPP stop list record by TPP authorisation number and national authority ID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<TppStopListRecord> getTppStopListRecord(@ApiParam(value="ID of TPP", example="12345987") @RequestHeader(value="tpp-authorisation-number") String tppAuthorisationNumber, @ApiParam(value="National competent authority id", example="authority id") @RequestHeader(value="authority-id") String nationalAuthorityId, @ApiParam(value="Service instance id", example="instance id") @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String instanceId) {
        return this.cmsAspspTppService.getTppStopListRecord(tppAuthorisationNumber, nationalAuthorityId, instanceId).map(record -> new ResponseEntity(record, HttpStatus.OK)).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    @PutMapping(path={"/block"})
    @ApiOperation(value="Blocks TPP by TPP authorisation number, national authority ID and lock period")
    @ApiResponse(code=200, message="OK")
    public ResponseEntity<Boolean> blockTpp(@ApiParam(value="ID of TPP", example="12345987") @RequestHeader(value="tpp-authorisation-number") String tppAuthorisationNumber, @ApiParam(value="National competent authority id", example="authority id") @RequestHeader(value="authority-id") String nationalAuthorityId, @ApiParam(value="Service instance id", example="instance id") @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String instanceId, @ApiParam(value="Period of TPP locking (in milliseconds)", example="1000") @RequestHeader(value="lock-period", required=false) Long lockPeriod) {
        Duration lockPeriodDuration = lockPeriod != null ? Duration.ofMillis(lockPeriod) : null;
        boolean isBlocked = this.cmsAspspTppService.blockTpp(tppAuthorisationNumber, nationalAuthorityId, instanceId, lockPeriodDuration);
        return new ResponseEntity((Object)isBlocked, HttpStatus.OK);
    }

    @DeleteMapping(path={"/unblock"})
    @ApiOperation(value="Unblocks TPP by TPP authorisation number and national authority ID")
    @ApiResponse(code=200, message="OK")
    public ResponseEntity<Boolean> unblockTpp(@ApiParam(value="ID of TPP", example="12345987") @RequestHeader(value="tpp-authorisation-number") String tppAuthorisationNumber, @ApiParam(value="National competent authority id", example="authority id") @RequestHeader(value="authority-id") String nationalAuthorityId, @ApiParam(value="Service instance id", example="instance id") @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String instanceId) {
        boolean isUnblocked = this.cmsAspspTppService.unblockTpp(tppAuthorisationNumber, nationalAuthorityId, instanceId);
        return new ResponseEntity((Object)isUnblocked, HttpStatus.OK);
    }

    @ConstructorProperties(value={"cmsAspspTppService"})
    public CmsAspspStopListController(CmsAspspTppService cmsAspspTppService) {
        this.cmsAspspTppService = cmsAspspTppService;
    }
}

