/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.aspsp.controller;

import de.adorsys.psd2.consent.api.CmsPageInfo;
import de.adorsys.psd2.consent.api.ResponseData;
import de.adorsys.psd2.consent.api.piis.v1.CmsPiisConsent;
import de.adorsys.psd2.consent.aspsp.api.CmsAspspPiisExportApi;
import de.adorsys.psd2.consent.aspsp.api.PageData;
import de.adorsys.psd2.consent.aspsp.api.piis.CmsAspspPiisFundsExportService;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collection;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CmsAspspPiisExportController
implements CmsAspspPiisExportApi {
    private final CmsAspspPiisFundsExportService cmsAspspPiisExportService;

    public ResponseData<Collection<CmsPiisConsent>> getConsentsByTpp(String tppId, LocalDate start, LocalDate end, String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, String instanceId, Integer pageIndex, Integer itemsPerPage) {
        PsuIdData psuIdData = new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType, null);
        PageData consents = this.cmsAspspPiisExportService.exportConsentsByTpp(tppId, start, end, psuIdData, instanceId, pageIndex, itemsPerPage);
        return ResponseData.list((Object)((Collection)consents.getData()), (CmsPageInfo)new CmsPageInfo(consents.getPage(), consents.getPageSize(), consents.getTotal()), (Object)HttpStatus.OK);
    }

    public ResponseData<Collection<CmsPiisConsent>> getConsentsByPsu(LocalDate start, LocalDate end, String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, String instanceId, Integer pageIndex, Integer itemsPerPage) {
        PsuIdData psuIdData = new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType, null);
        PageData consents = this.cmsAspspPiisExportService.exportConsentsByPsu(psuIdData, start, end, instanceId, pageIndex, itemsPerPage);
        return ResponseData.list((Object)((Collection)consents.getData()), (CmsPageInfo)new CmsPageInfo(consents.getPage(), consents.getPageSize(), consents.getTotal()), (Object)HttpStatus.OK);
    }

    public ResponseData<Collection<CmsPiisConsent>> getConsentsByAccountId(String aspspAccountId, LocalDate start, LocalDate end, String instanceId, Integer pageIndex, Integer itemsPerPage) {
        PageData consents = this.cmsAspspPiisExportService.exportConsentsByAccountId(aspspAccountId, start, end, instanceId, pageIndex, itemsPerPage);
        return ResponseData.list((Object)((Collection)consents.getData()), (CmsPageInfo)new CmsPageInfo(consents.getPage(), consents.getPageSize(), consents.getTotal()), (Object)HttpStatus.OK);
    }

    @ConstructorProperties(value={"cmsAspspPiisExportService"})
    public CmsAspspPiisExportController(CmsAspspPiisFundsExportService cmsAspspPiisExportService) {
        this.cmsAspspPiisExportService = cmsAspspPiisExportService;
    }
}

