/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.aspsp.controller;

import de.adorsys.psd2.consent.api.CmsPageInfo;
import de.adorsys.psd2.consent.api.ResponseData;
import de.adorsys.psd2.consent.api.ais.CmsAisAccountConsent;
import de.adorsys.psd2.consent.aspsp.api.CmsAspspAisExportApi;
import de.adorsys.psd2.consent.aspsp.api.PageData;
import de.adorsys.psd2.consent.aspsp.api.ais.CmsAspspAisExportService;
import de.adorsys.psd2.xs2a.core.pagination.data.PageRequestParameters;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collection;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CmsAspspAisExportController
implements CmsAspspAisExportApi {
    private final CmsAspspAisExportService cmsAspspAisExportService;

    public ResponseData<Collection<CmsAisAccountConsent>> getConsentsByTpp(String tppId, LocalDate start, LocalDate end, String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, String instanceId, Integer pageIndex, Integer itemsPerPage, String additionalTppInfo) {
        PsuIdData psuIdData = new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType, null);
        PageRequestParameters pageRequestParameters = new PageRequestParameters(pageIndex, itemsPerPage);
        PageData consents = this.cmsAspspAisExportService.exportConsentsByTpp(tppId, start, end, psuIdData, instanceId, pageRequestParameters, additionalTppInfo);
        return ResponseData.list((Object)((Collection)consents.getData()), (CmsPageInfo)new CmsPageInfo(consents.getPage(), consents.getPageSize(), consents.getTotal()), (Object)HttpStatus.OK);
    }

    public ResponseData<Collection<CmsAisAccountConsent>> getConsentsByPsu(LocalDate start, LocalDate end, String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, String instanceId, Integer pageIndex, Integer itemsPerPage, String additionalTppInfo) {
        PsuIdData psuIdData = new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType, null);
        PageData consents = this.cmsAspspAisExportService.exportConsentsByPsuAndAdditionalTppInfo(psuIdData, start, end, instanceId, pageIndex, itemsPerPage, additionalTppInfo);
        return ResponseData.list((Object)((Collection)consents.getData()), (CmsPageInfo)new CmsPageInfo(consents.getPage(), consents.getPageSize(), consents.getTotal()), (Object)HttpStatus.OK);
    }

    public ResponseData<Collection<CmsAisAccountConsent>> getConsentsByAccount(String aspspAccountId, LocalDate start, LocalDate end, String instanceId, Integer pageIndex, Integer itemsPerPage, String additionalTppInfo) {
        PageData consents = this.cmsAspspAisExportService.exportConsentsByAccountIdAndAdditionalTppInfo(aspspAccountId, start, end, instanceId, pageIndex, itemsPerPage, additionalTppInfo);
        return ResponseData.list((Object)((Collection)consents.getData()), (CmsPageInfo)new CmsPageInfo(consents.getPage(), consents.getPageSize(), consents.getTotal()), (Object)HttpStatus.OK);
    }

    @ConstructorProperties(value={"cmsAspspAisExportService"})
    public CmsAspspAisExportController(CmsAspspAisExportService cmsAspspAisExportService) {
        this.cmsAspspAisExportService = cmsAspspAisExportService;
    }
}

