/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.aspsp.controller;

import de.adorsys.psd2.consent.aspsp.api.CmsAspspEventApi;
import de.adorsys.psd2.event.core.model.EventOrigin;
import de.adorsys.psd2.event.core.model.EventType;
import de.adorsys.psd2.event.service.AspspEventService;
import de.adorsys.psd2.event.service.model.AspspEvent;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CmsAspspEventController
implements CmsAspspEventApi {
    private static final Logger log = LoggerFactory.getLogger(CmsAspspEventController.class);
    private final AspspEventService aspspEventService;

    public ResponseEntity<List<AspspEvent>> getEventsForDates(OffsetDateTime start, OffsetDateTime end, String instanceId, Integer pageIndex, Integer itemsPerPage) {
        List events = this.aspspEventService.getEventsForPeriod(start, end, instanceId, pageIndex, itemsPerPage);
        return new ResponseEntity((Object)events, HttpStatus.OK);
    }

    public ResponseEntity<List<AspspEvent>> getEventsForDatesAndConsentId(String consentId, OffsetDateTime start, OffsetDateTime end, String instanceId, Integer pageIndex, Integer itemsPerPage) {
        List events = this.aspspEventService.getEventsForPeriodAndConsentId(start, end, consentId, instanceId, pageIndex, itemsPerPage);
        return new ResponseEntity((Object)events, HttpStatus.OK);
    }

    public ResponseEntity<List<AspspEvent>> getEventsForDatesAndPaymentId(String paymentId, OffsetDateTime start, OffsetDateTime end, String instanceId, Integer pageIndex, Integer itemsPerPage) {
        List events = this.aspspEventService.getEventsForPeriodAndPaymentId(start, end, paymentId, instanceId, pageIndex, itemsPerPage);
        return new ResponseEntity((Object)events, HttpStatus.OK);
    }

    public ResponseEntity<List<AspspEvent>> getEventsForDatesAndEventType(String eventType, OffsetDateTime start, OffsetDateTime end, String instanceId, Integer pageIndex, Integer itemsPerPage) {
        EventType eventTypeValue;
        try {
            eventTypeValue = EventType.valueOf((String)eventType);
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.badRequest().build();
        }
        List events = this.aspspEventService.getEventsForPeriodAndEventType(start, end, eventTypeValue, instanceId, pageIndex, itemsPerPage);
        return new ResponseEntity((Object)events, HttpStatus.OK);
    }

    public ResponseEntity<List<AspspEvent>> getEventsForDatesAndEventOrigin(String eventOrigin, OffsetDateTime start, OffsetDateTime end, String instanceId, Integer pageIndex, Integer itemsPerPage) {
        EventOrigin eventOriginValue;
        try {
            eventOriginValue = EventOrigin.valueOf((String)eventOrigin);
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.badRequest().build();
        }
        List events = this.aspspEventService.getEventsForPeriodAndEventOrigin(start, end, eventOriginValue, instanceId, pageIndex, itemsPerPage);
        return new ResponseEntity((Object)events, HttpStatus.OK);
    }

    @ConstructorProperties(value={"aspspEventService"})
    public CmsAspspEventController(AspspEventService aspspEventService) {
        this.aspspEventService = aspspEventService;
    }
}

