/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.aspsp.controller;

import de.adorsys.psd2.consent.api.CmsPageInfo;
import de.adorsys.psd2.consent.api.ResponseData;
import de.adorsys.psd2.consent.api.pis.CmsBasePaymentResponse;
import de.adorsys.psd2.consent.aspsp.api.CmsAspspPisExportApi;
import de.adorsys.psd2.consent.aspsp.api.PageData;
import de.adorsys.psd2.consent.aspsp.api.pis.CmsAspspPisExportService;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collection;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CmsAspspPisExportController
implements CmsAspspPisExportApi {
    private final CmsAspspPisExportService cmsAspspPisExportService;

    public ResponseData<Collection<CmsBasePaymentResponse>> getPaymentsByTpp(String tppId, LocalDate start, LocalDate end, String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, String instanceId, Integer pageIndex, Integer itemsPerPage) {
        PsuIdData psuIdData = new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType, null);
        PageData payments = this.cmsAspspPisExportService.exportPaymentsByTpp(tppId, start, end, psuIdData, instanceId, pageIndex, itemsPerPage);
        return ResponseData.list((Object)((Collection)payments.getData()), (CmsPageInfo)new CmsPageInfo(payments.getPage(), payments.getPageSize(), payments.getTotal()), (Object)HttpStatus.OK);
    }

    public ResponseData<Collection<CmsBasePaymentResponse>> getPaymentsByPsu(LocalDate start, LocalDate end, String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, String instanceId, Integer pageIndex, Integer itemsPerPage) {
        PsuIdData psuIdData = new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType, null);
        PageData payments = this.cmsAspspPisExportService.exportPaymentsByPsu(psuIdData, start, end, instanceId, pageIndex, itemsPerPage);
        return ResponseData.list((Object)((Collection)payments.getData()), (CmsPageInfo)new CmsPageInfo(payments.getPage(), payments.getPageSize(), payments.getTotal()), (Object)HttpStatus.OK);
    }

    public ResponseData<Collection<CmsBasePaymentResponse>> getPaymentsByAccountId(String aspspAccountId, LocalDate start, LocalDate end, String instanceId, Integer pageIndex, Integer itemsPerPage) {
        PageData payments = this.cmsAspspPisExportService.exportPaymentsByAccountId(aspspAccountId, start, end, instanceId, pageIndex, itemsPerPage);
        return ResponseData.list((Object)((Collection)payments.getData()), (CmsPageInfo)new CmsPageInfo(payments.getPage(), payments.getPageSize(), payments.getTotal()), (Object)HttpStatus.OK);
    }

    @ConstructorProperties(value={"cmsAspspPisExportService"})
    public CmsAspspPisExportController(CmsAspspPisExportService cmsAspspPisExportService) {
        this.cmsAspspPisExportService = cmsAspspPisExportService;
    }
}

