/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.aspsp.domain;

import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.List;

@ApiModel(description="Piis consent request", value="PiisConsentRequest")
public class CreatePiisConsentRequest {
    @ApiModelProperty(value="Tpp for which the consent will be created. If the property is omitted, the consent will be created for all TPPs")
    private TppInfo tppInfo;
    @ApiModelProperty(value="Accounts for which the consent is created")
    private List<AccountReference> accounts;
    @ApiModelProperty(value="Consent`s expiration date. The content is the local ASPSP date in ISODate Format", example="2020-10-10")
    private LocalDate validUntil;
    @ApiModelProperty(value="Maximum frequency for an access per day. For a once-off access, this attribute is set to 1", required=true, example="4")
    private int allowedFrequencyPerDay;

    public TppInfo getTppInfo() {
        return this.tppInfo;
    }

    public List<AccountReference> getAccounts() {
        return this.accounts;
    }

    public LocalDate getValidUntil() {
        return this.validUntil;
    }

    public int getAllowedFrequencyPerDay() {
        return this.allowedFrequencyPerDay;
    }

    public void setTppInfo(TppInfo tppInfo) {
        this.tppInfo = tppInfo;
    }

    public void setAccounts(List<AccountReference> accounts) {
        this.accounts = accounts;
    }

    public void setValidUntil(LocalDate validUntil) {
        this.validUntil = validUntil;
    }

    public void setAllowedFrequencyPerDay(int allowedFrequencyPerDay) {
        this.allowedFrequencyPerDay = allowedFrequencyPerDay;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreatePiisConsentRequest)) {
            return false;
        }
        CreatePiisConsentRequest other = (CreatePiisConsentRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TppInfo this$tppInfo = this.getTppInfo();
        TppInfo other$tppInfo = other.getTppInfo();
        if (this$tppInfo == null ? other$tppInfo != null : !this$tppInfo.equals(other$tppInfo)) {
            return false;
        }
        List<AccountReference> this$accounts = this.getAccounts();
        List<AccountReference> other$accounts = other.getAccounts();
        if (this$accounts == null ? other$accounts != null : !((Object)this$accounts).equals(other$accounts)) {
            return false;
        }
        LocalDate this$validUntil = this.getValidUntil();
        LocalDate other$validUntil = other.getValidUntil();
        if (this$validUntil == null ? other$validUntil != null : !((Object)this$validUntil).equals(other$validUntil)) {
            return false;
        }
        return this.getAllowedFrequencyPerDay() == other.getAllowedFrequencyPerDay();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreatePiisConsentRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TppInfo $tppInfo = this.getTppInfo();
        result = result * 59 + ($tppInfo == null ? 43 : $tppInfo.hashCode());
        List<AccountReference> $accounts = this.getAccounts();
        result = result * 59 + ($accounts == null ? 43 : ((Object)$accounts).hashCode());
        LocalDate $validUntil = this.getValidUntil();
        result = result * 59 + ($validUntil == null ? 43 : ((Object)$validUntil).hashCode());
        result = result * 59 + this.getAllowedFrequencyPerDay();
        return result;
    }

    public String toString() {
        return "CreatePiisConsentRequest(tppInfo=" + this.getTppInfo() + ", accounts=" + this.getAccounts() + ", validUntil=" + this.getValidUntil() + ", allowedFrequencyPerDay=" + this.getAllowedFrequencyPerDay() + ")";
    }
}

