/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.aspsp.api;

import de.adorsys.psd2.consent.api.piis.v1.CmsPiisConsent;
import de.adorsys.psd2.consent.aspsp.api.piis.CreatePiisConsentRequest;
import de.adorsys.psd2.consent.aspsp.api.piis.CreatePiisConsentResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(path={"aspsp-api/v1/piis/consents"})
@Api(value="aspsp-api/v1/piis/consents", tags={"ASPSP PIIS, Consents"})
public interface CmsAspspPiisApi {
    @PostMapping
    @ApiOperation(value="Creates new PIIS consent")
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=String.class), @ApiResponse(code=400, message="Bad Request")})
    public ResponseEntity<CreatePiisConsentResponse> createConsent(@RequestBody CreatePiisConsentRequest var1, @ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String var2, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String var3, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String var4, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String var5, @ApiParam(value="ID of the particular service instance") @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String var6);

    @GetMapping
    @ApiOperation(value="Returns a list of PIIS Consent objects by PSU ID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<List<CmsPiisConsent>> getConsentsForPsu(@ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String var1, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String var2, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String var3, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String var4, @ApiParam(value="ID of the particular service instance") @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String var5, @RequestParam(value="pageIndex", required=false) Integer var6, @RequestParam(value="itemsPerPage", required=false) Integer var7);

    @DeleteMapping(path={"/{consent-id}"})
    @ApiOperation(value="Terminates PIIS Consent object by its ID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Boolean.class), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Boolean> terminateConsent(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="consent-id") String var1, @ApiParam(value="ID of the particular service instance") @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String var2);
}

