/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.aspsp.api;

import de.adorsys.psd2.consent.api.pis.CmsPayment;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.time.LocalDate;
import java.util.Collection;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;

@RequestMapping(path={"aspsp-api/v1/pis/payments"})
@Api(value="aspsp-api/v1/pis/payments", tags={"ASPSP Export Payments"})
public interface CmsAspspPisExportApi {
    @GetMapping(path={"/tpp/{tpp-id}"})
    @ApiOperation(value="Returns a list of payments by given mandatory TPP ID, optional creation date, PSU ID Data and instance ID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public ResponseEntity<Collection<CmsPayment>> getPaymentsByTpp(@ApiParam(value="TPP ID", required=true, example="12345987") @PathVariable(value="tpp-id") String var1, @ApiParam(value="Creation start date", example="2010-01-01") @RequestHeader(value="start-date", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate var2, @ApiParam(value="Creation end date", example="2030-01-01") @RequestHeader(value="end-date", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate var3, @ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String var4, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String var5, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String var6, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String var7, @ApiParam(value="ID of the particular service instance") @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String var8);

    @GetMapping(path={"/psu"})
    @ApiOperation(value="Returns a list of payments by given mandatory PSU ID Data, optional creation date and instance ID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public ResponseEntity<Collection<CmsPayment>> getPaymentsByPsu(@ApiParam(value="Creation start date", example="2010-01-01") @RequestHeader(value="start-date", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate var1, @ApiParam(value="Creation end date", example="2030-01-01") @RequestHeader(value="end-date", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate var2, @ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String var3, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String var4, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String var5, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String var6, @ApiParam(value="ID of the particular service instance") @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String var7);

    @GetMapping(path={"/account/{account-id}"})
    @ApiOperation(value="Returns a list of payments by given mandatory aspsp account id, optional creation date and instance ID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public ResponseEntity<Collection<CmsPayment>> getPaymentsByAccountId(@ApiParam(value="Bank specific account identifier.", required=true, example="11111-99999") @PathVariable(value="account-id") String var1, @ApiParam(value="Creation start date", example="2010-01-01") @RequestHeader(value="start-date", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate var2, @ApiParam(value="Creation end date", example="2030-01-01") @RequestHeader(value="end-date", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate var3, @ApiParam(value="ID of the particular service instance") @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String var4);
}

