/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.aspsp.api.piis;

import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.List;

@ApiModel(description="Piis consent request", value="PiisConsentRequest")
public class CreatePiisConsentRequest {
    @ApiModelProperty(value="Tpp for which the consent will be created. If the property is omitted, the consent will be created for all TPPs")
    private TppInfo tppInfo;
    @ApiModelProperty(value="Accounts for which the consent is created")
    private List<AccountReference> accounts;
    @ApiModelProperty(value="Consent`s expiration date. The content is the local ASPSP date in ISODate Format", example="2020-10-10")
    private LocalDate validUntil;
    @ApiModelProperty(value="Maximum frequency for an access per day. For a once-off access, this attribute is set to 1", required=true, example="4")
    private int allowedFrequencyPerDay;
    @ApiModelProperty(value="Card Number of the card issued by the PIISP. Should be delivered if available.", example="1234567891234")
    private String cardNumber;
    @ApiModelProperty(value="Expiry date of the card issued by the PIISP", example="2020-12-31")
    private LocalDate cardExpiryDate;
    @ApiModelProperty(value="Additional explanation for the card product.", example="MyMerchant Loyalty Card")
    private String cardInformation;
    @ApiModelProperty(value="Additional information about the registration process for the PSU, e.g. a reference to the TPP / PSU contract.", example="Your contract Number 1234 with MyMerchant is completed with the registration with your bank.")
    private String registrationInformation;

    public TppInfo getTppInfo() {
        return this.tppInfo;
    }

    public List<AccountReference> getAccounts() {
        return this.accounts;
    }

    public LocalDate getValidUntil() {
        return this.validUntil;
    }

    public int getAllowedFrequencyPerDay() {
        return this.allowedFrequencyPerDay;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public LocalDate getCardExpiryDate() {
        return this.cardExpiryDate;
    }

    public String getCardInformation() {
        return this.cardInformation;
    }

    public String getRegistrationInformation() {
        return this.registrationInformation;
    }

    public void setTppInfo(TppInfo tppInfo) {
        this.tppInfo = tppInfo;
    }

    public void setAccounts(List<AccountReference> accounts) {
        this.accounts = accounts;
    }

    public void setValidUntil(LocalDate validUntil) {
        this.validUntil = validUntil;
    }

    public void setAllowedFrequencyPerDay(int allowedFrequencyPerDay) {
        this.allowedFrequencyPerDay = allowedFrequencyPerDay;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public void setCardExpiryDate(LocalDate cardExpiryDate) {
        this.cardExpiryDate = cardExpiryDate;
    }

    public void setCardInformation(String cardInformation) {
        this.cardInformation = cardInformation;
    }

    public void setRegistrationInformation(String registrationInformation) {
        this.registrationInformation = registrationInformation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreatePiisConsentRequest)) {
            return false;
        }
        CreatePiisConsentRequest other = (CreatePiisConsentRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TppInfo this$tppInfo = this.getTppInfo();
        TppInfo other$tppInfo = other.getTppInfo();
        if (this$tppInfo == null ? other$tppInfo != null : !this$tppInfo.equals(other$tppInfo)) {
            return false;
        }
        List<AccountReference> this$accounts = this.getAccounts();
        List<AccountReference> other$accounts = other.getAccounts();
        if (this$accounts == null ? other$accounts != null : !((Object)this$accounts).equals(other$accounts)) {
            return false;
        }
        LocalDate this$validUntil = this.getValidUntil();
        LocalDate other$validUntil = other.getValidUntil();
        if (this$validUntil == null ? other$validUntil != null : !((Object)this$validUntil).equals(other$validUntil)) {
            return false;
        }
        if (this.getAllowedFrequencyPerDay() != other.getAllowedFrequencyPerDay()) {
            return false;
        }
        String this$cardNumber = this.getCardNumber();
        String other$cardNumber = other.getCardNumber();
        if (this$cardNumber == null ? other$cardNumber != null : !this$cardNumber.equals(other$cardNumber)) {
            return false;
        }
        LocalDate this$cardExpiryDate = this.getCardExpiryDate();
        LocalDate other$cardExpiryDate = other.getCardExpiryDate();
        if (this$cardExpiryDate == null ? other$cardExpiryDate != null : !((Object)this$cardExpiryDate).equals(other$cardExpiryDate)) {
            return false;
        }
        String this$cardInformation = this.getCardInformation();
        String other$cardInformation = other.getCardInformation();
        if (this$cardInformation == null ? other$cardInformation != null : !this$cardInformation.equals(other$cardInformation)) {
            return false;
        }
        String this$registrationInformation = this.getRegistrationInformation();
        String other$registrationInformation = other.getRegistrationInformation();
        return !(this$registrationInformation == null ? other$registrationInformation != null : !this$registrationInformation.equals(other$registrationInformation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreatePiisConsentRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TppInfo $tppInfo = this.getTppInfo();
        result = result * 59 + ($tppInfo == null ? 43 : $tppInfo.hashCode());
        List<AccountReference> $accounts = this.getAccounts();
        result = result * 59 + ($accounts == null ? 43 : ((Object)$accounts).hashCode());
        LocalDate $validUntil = this.getValidUntil();
        result = result * 59 + ($validUntil == null ? 43 : ((Object)$validUntil).hashCode());
        result = result * 59 + this.getAllowedFrequencyPerDay();
        String $cardNumber = this.getCardNumber();
        result = result * 59 + ($cardNumber == null ? 43 : $cardNumber.hashCode());
        LocalDate $cardExpiryDate = this.getCardExpiryDate();
        result = result * 59 + ($cardExpiryDate == null ? 43 : ((Object)$cardExpiryDate).hashCode());
        String $cardInformation = this.getCardInformation();
        result = result * 59 + ($cardInformation == null ? 43 : $cardInformation.hashCode());
        String $registrationInformation = this.getRegistrationInformation();
        result = result * 59 + ($registrationInformation == null ? 43 : $registrationInformation.hashCode());
        return result;
    }

    public String toString() {
        return "CreatePiisConsentRequest(tppInfo=" + this.getTppInfo() + ", accounts=" + this.getAccounts() + ", validUntil=" + this.getValidUntil() + ", allowedFrequencyPerDay=" + this.getAllowedFrequencyPerDay() + ", cardNumber=" + this.getCardNumber() + ", cardExpiryDate=" + this.getCardExpiryDate() + ", cardInformation=" + this.getCardInformation() + ", registrationInformation=" + this.getRegistrationInformation() + ")";
    }
}

