/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.aspsp.api.piis;

import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;

@ApiModel(description="Piis consent request", value="PiisConsentRequest")
public class CreatePiisConsentRequest {
    @ApiModelProperty(value="Tpp attribute that fully described Tpp for which the consent will be created. If the property is omitted, the consent will be created for all TPPs")
    private String tppAuthorisationNumber;
    @ApiModelProperty(value="Account, where the confirmation of funds service is aimed to be submitted to.")
    private AccountReference account;
    @ApiModelProperty(value="Consent`s expiration date. The content is the local ASPSP date in ISODate Format", example="2020-10-10")
    private LocalDate validUntil;
    @ApiModelProperty(value="Card Number of the card issued by the PIISP. Should be delivered if available.", example="1234567891234")
    private String cardNumber;
    @ApiModelProperty(value="Expiry date of the card issued by the PIISP", example="2020-12-31")
    private LocalDate cardExpiryDate;
    @ApiModelProperty(value="Additional explanation for the card product.", example="MyMerchant Loyalty Card")
    private String cardInformation;
    @ApiModelProperty(value="Additional information about the registration process for the PSU, e.g. a reference to the TPP / PSU contract.", example="Your contract Number 1234 with MyMerchant is completed with the registration with your bank.")
    private String registrationInformation;

    public String getTppAuthorisationNumber() {
        return this.tppAuthorisationNumber;
    }

    public AccountReference getAccount() {
        return this.account;
    }

    public LocalDate getValidUntil() {
        return this.validUntil;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public LocalDate getCardExpiryDate() {
        return this.cardExpiryDate;
    }

    public String getCardInformation() {
        return this.cardInformation;
    }

    public String getRegistrationInformation() {
        return this.registrationInformation;
    }

    public void setTppAuthorisationNumber(String tppAuthorisationNumber) {
        this.tppAuthorisationNumber = tppAuthorisationNumber;
    }

    public void setAccount(AccountReference account) {
        this.account = account;
    }

    public void setValidUntil(LocalDate validUntil) {
        this.validUntil = validUntil;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public void setCardExpiryDate(LocalDate cardExpiryDate) {
        this.cardExpiryDate = cardExpiryDate;
    }

    public void setCardInformation(String cardInformation) {
        this.cardInformation = cardInformation;
    }

    public void setRegistrationInformation(String registrationInformation) {
        this.registrationInformation = registrationInformation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreatePiisConsentRequest)) {
            return false;
        }
        CreatePiisConsentRequest other = (CreatePiisConsentRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tppAuthorisationNumber = this.getTppAuthorisationNumber();
        String other$tppAuthorisationNumber = other.getTppAuthorisationNumber();
        if (this$tppAuthorisationNumber == null ? other$tppAuthorisationNumber != null : !this$tppAuthorisationNumber.equals(other$tppAuthorisationNumber)) {
            return false;
        }
        AccountReference this$account = this.getAccount();
        AccountReference other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        LocalDate this$validUntil = this.getValidUntil();
        LocalDate other$validUntil = other.getValidUntil();
        if (this$validUntil == null ? other$validUntil != null : !((Object)this$validUntil).equals(other$validUntil)) {
            return false;
        }
        String this$cardNumber = this.getCardNumber();
        String other$cardNumber = other.getCardNumber();
        if (this$cardNumber == null ? other$cardNumber != null : !this$cardNumber.equals(other$cardNumber)) {
            return false;
        }
        LocalDate this$cardExpiryDate = this.getCardExpiryDate();
        LocalDate other$cardExpiryDate = other.getCardExpiryDate();
        if (this$cardExpiryDate == null ? other$cardExpiryDate != null : !((Object)this$cardExpiryDate).equals(other$cardExpiryDate)) {
            return false;
        }
        String this$cardInformation = this.getCardInformation();
        String other$cardInformation = other.getCardInformation();
        if (this$cardInformation == null ? other$cardInformation != null : !this$cardInformation.equals(other$cardInformation)) {
            return false;
        }
        String this$registrationInformation = this.getRegistrationInformation();
        String other$registrationInformation = other.getRegistrationInformation();
        return !(this$registrationInformation == null ? other$registrationInformation != null : !this$registrationInformation.equals(other$registrationInformation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreatePiisConsentRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tppAuthorisationNumber = this.getTppAuthorisationNumber();
        result = result * 59 + ($tppAuthorisationNumber == null ? 43 : $tppAuthorisationNumber.hashCode());
        AccountReference $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        LocalDate $validUntil = this.getValidUntil();
        result = result * 59 + ($validUntil == null ? 43 : ((Object)$validUntil).hashCode());
        String $cardNumber = this.getCardNumber();
        result = result * 59 + ($cardNumber == null ? 43 : $cardNumber.hashCode());
        LocalDate $cardExpiryDate = this.getCardExpiryDate();
        result = result * 59 + ($cardExpiryDate == null ? 43 : ((Object)$cardExpiryDate).hashCode());
        String $cardInformation = this.getCardInformation();
        result = result * 59 + ($cardInformation == null ? 43 : $cardInformation.hashCode());
        String $registrationInformation = this.getRegistrationInformation();
        result = result * 59 + ($registrationInformation == null ? 43 : $registrationInformation.hashCode());
        return result;
    }

    public String toString() {
        return "CreatePiisConsentRequest(tppAuthorisationNumber=" + this.getTppAuthorisationNumber() + ", account=" + this.getAccount() + ", validUntil=" + this.getValidUntil() + ", cardNumber=" + this.getCardNumber() + ", cardExpiryDate=" + this.getCardExpiryDate() + ", cardInformation=" + this.getCardInformation() + ", registrationInformation=" + this.getRegistrationInformation() + ")";
    }
}

