/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.aspsp.api;

import de.adorsys.psd2.xs2a.core.tpp.TppStopListRecord;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;

@RequestMapping(path={"aspsp-api/v1/tpp/stop-list"})
@Api(value="aspsp-api/v1/tpp/stop-list", tags={"ASPSP TPP Stop List"})
public interface CmsAspspStopListApi {
    @GetMapping
    @ApiOperation(value="Returns TPP stop list record by TPP authorisation number")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<TppStopListRecord> getTppStopListRecord(@ApiParam(value="ID of TPP", example="12345987") @RequestHeader(value="tpp-authorisation-number") String var1, @ApiParam(value="Service instance id", example="instance id") @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String var2);

    @PutMapping(path={"/block"})
    @ApiOperation(value="Blocks TPP by TPP authorisation number and lock period")
    @ApiResponse(code=200, message="OK")
    public ResponseEntity<Boolean> blockTpp(@ApiParam(value="ID of TPP", example="12345987") @RequestHeader(value="tpp-authorisation-number") String var1, @ApiParam(value="Service instance id", example="instance id") @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String var2, @ApiParam(value="Period of TPP locking (in milliseconds)", example="1000") @RequestHeader(value="lock-period", required=false) Long var3);

    @DeleteMapping(path={"/unblock"})
    @ApiOperation(value="Unblocks TPP by TPP authorisation number")
    @ApiResponse(code=200, message="OK")
    public ResponseEntity<Boolean> unblockTpp(@ApiParam(value="ID of TPP", example="12345987") @RequestHeader(value="tpp-authorisation-number") String var1, @ApiParam(value="Service instance id", example="instance id") @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String var2);
}

