/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.aspsp.api;

import de.adorsys.psd2.event.service.model.AspspEvent;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.time.OffsetDateTime;
import java.util.List;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(path={"aspsp-api/v1/events"})
@Api(value="aspsp-api/v1/events", tags={"ASPSP Events"})
public interface CmsAspspEventApi {
    @GetMapping(path={"/"})
    @ApiOperation(value="Returns a list of Event objects between two dates")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public ResponseEntity<List<AspspEvent>> getEventsForDates(@ApiParam(value="Start date", example="2010-01-01T00:00:00Z", required=true) @RequestHeader(value="start-date") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime var1, @ApiParam(value="End date", example="2030-01-01T00:00:00Z", required=true) @RequestHeader(value="end-date") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime var2, @ApiParam(value="Bank instance ID") @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String var3, @ApiParam(value="Index of current page", example="0") @RequestParam(value="pageIndex", defaultValue="0") Integer var4, @ApiParam(value="Quantity of consents on one page", example="20") @RequestParam(value="itemsPerPage", defaultValue="20") Integer var5);

    @GetMapping(path={"/consent/{consent-id}"})
    @ApiOperation(value="Returns a list of Event objects between two dates")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public ResponseEntity<List<AspspEvent>> getEventsForDatesAndConsentId(@ApiParam(name="consent-id", value="The consent identifier", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="consent-id") String var1, @ApiParam(value="Start date", example="2010-01-01T00:00:00Z", required=true) @RequestHeader(value="start-date") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime var2, @ApiParam(value="End date", example="2030-01-01T00:00:00Z", required=true) @RequestHeader(value="end-date") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime var3, @ApiParam(value="Bank instance ID") @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String var4, @ApiParam(value="Index of current page", example="0") @RequestParam(value="pageIndex", defaultValue="0") Integer var5, @ApiParam(value="Quantity of consents on one page", example="20") @RequestParam(value="itemsPerPage", defaultValue="20") Integer var6);

    @GetMapping(path={"/payment/{payment-id}"})
    @ApiOperation(value="Returns a list of Event objects between two dates")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public ResponseEntity<List<AspspEvent>> getEventsForDatesAndPaymentId(@ApiParam(name="payment-id", value="The payment identification assigned to the created payment.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="payment-id") String var1, @ApiParam(value="Start date", example="2010-01-01T00:00:00Z", required=true) @RequestHeader(value="start-date") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime var2, @ApiParam(value="End date", example="2030-01-01T00:00:00Z", required=true) @RequestHeader(value="end-date") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime var3, @ApiParam(value="Bank instance ID") @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String var4, @ApiParam(value="Index of current page", example="0") @RequestParam(value="pageIndex", defaultValue="0") Integer var5, @ApiParam(value="Quantity of consents on one page", example="20") @RequestParam(value="itemsPerPage", defaultValue="20") Integer var6);

    @GetMapping(path={"/type/{event-type}"})
    @ApiOperation(value="Returns a list of Event objects between two dates")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public ResponseEntity<List<AspspEvent>> getEventsForDatesAndEventType(@ApiParam(name="event-type", value="The type of event", example="CREATE_SIGNING_BASKET_REQUEST_RECEIVED", required=true) @PathVariable(value="event-type") String var1, @ApiParam(value="Start date", example="2010-01-01T00:00:00Z", required=true) @RequestHeader(value="start-date") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime var2, @ApiParam(value="End date", example="2030-01-01T00:00:00Z", required=true) @RequestHeader(value="end-date") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime var3, @ApiParam(value="Bank instance ID") @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String var4, @ApiParam(value="Index of current page", example="0") @RequestParam(value="pageIndex", defaultValue="0") Integer var5, @ApiParam(value="Quantity of consents on one page", example="20") @RequestParam(value="itemsPerPage", defaultValue="20") Integer var6);

    @GetMapping(path={"/origin/{event-origin}"})
    @ApiOperation(value="Returns a list of Event objects between two dates")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public ResponseEntity<List<AspspEvent>> getEventsForDatesAndEventOrigin(@ApiParam(name="event-origin", value="The origin of event", example="ASPSP", required=true) @PathVariable(value="event-origin") String var1, @ApiParam(value="Start date", example="2010-01-01T00:00:00Z", required=true) @RequestHeader(value="start-date") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime var2, @ApiParam(value="End date", example="2030-01-01T00:00:00Z", required=true) @RequestHeader(value="end-date") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime var3, @ApiParam(value="Bank instance ID") @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String var4, @ApiParam(value="Index of current page", example="0") @RequestParam(value="pageIndex", defaultValue="0") Integer var5, @ApiParam(value="Quantity of consents on one page", example="20") @RequestParam(value="itemsPerPage", defaultValue="20") Integer var6);
}

