/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.api.pis;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum PisPaymentType {
    BULK("bulk"),
    PERIODIC("periodic"),
    FUTURE_DATED("delayed"),
    SINGLE("single");

    private static final Map<String, PisPaymentType> container;
    private String value;

    private PisPaymentType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static Optional<PisPaymentType> getByValue(String value) {
        return Optional.ofNullable(container.get(value));
    }

    static {
        container = new HashMap<String, PisPaymentType>();
        for (PisPaymentType type : PisPaymentType.values()) {
            container.put(type.getValue(), type);
        }
    }
}

