/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.scheduler;

import de.adorsys.psd2.consent.repository.PisCommonPaymentDataRepository;
import de.adorsys.psd2.consent.service.PisCommonPaymentConfirmationExpirationService;
import de.adorsys.psd2.scheduler.PageableSchedulerTask;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class NotConfirmedPaymentExpirationScheduleTask
extends PageableSchedulerTask {
    private static final Logger log = LoggerFactory.getLogger(NotConfirmedPaymentExpirationScheduleTask.class);
    private final PisCommonPaymentConfirmationExpirationService pisCommonPaymentConfirmationExpirationService;
    private final PisCommonPaymentDataRepository paymentDataRepository;

    @Scheduled(cron="${xs2a.cms.not-confirmed-payment-expiration.cron.expression}")
    @Transactional
    public void obsoleteNotConfirmedPaymentIfExpired() {
        long start = System.currentTimeMillis();
        log.info("Not confirmed payment expiration schedule task is run!");
        Long totalItems = this.paymentDataRepository.countByTransactionStatusIn(EnumSet.of(TransactionStatus.RCVD, TransactionStatus.PATC));
        log.debug("Found {} non confirmed payment items for expiration checking", (Object)totalItems);
        this.execute(totalItems);
        log.info("Not confirmed payment expiration schedule task completed in {}ms!", (Object)(System.currentTimeMillis() - start));
    }

    @Override
    protected void executePageable(Pageable pageable) {
        List expiredNotConfirmedPayments = this.paymentDataRepository.findByTransactionStatusIn(EnumSet.of(TransactionStatus.RCVD, TransactionStatus.PATC), pageable).stream().filter(arg_0 -> ((PisCommonPaymentConfirmationExpirationService)this.pisCommonPaymentConfirmationExpirationService).isConfirmationExpired(arg_0)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(expiredNotConfirmedPayments)) {
            this.pisCommonPaymentConfirmationExpirationService.updatePaymentDataListOnConfirmationExpiration(expiredNotConfirmedPayments);
        }
    }

    @ConstructorProperties(value={"pisCommonPaymentConfirmationExpirationService", "paymentDataRepository"})
    public NotConfirmedPaymentExpirationScheduleTask(PisCommonPaymentConfirmationExpirationService pisCommonPaymentConfirmationExpirationService, PisCommonPaymentDataRepository paymentDataRepository) {
        this.pisCommonPaymentConfirmationExpirationService = pisCommonPaymentConfirmationExpirationService;
        this.paymentDataRepository = paymentDataRepository;
    }
}

