/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.scheduler;

import de.adorsys.psd2.consent.repository.ConsentJpaRepository;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class NonRecurringConsentExpirationScheduleTask {
    private static final Logger log = LoggerFactory.getLogger(NonRecurringConsentExpirationScheduleTask.class);
    private final ConsentJpaRepository consentJpaRepository;

    @Scheduled(cron="${xs2a.cms.used-non-recurring-consent-expiration.cron.expression}")
    @Transactional
    public void expireUsedNonRecurringConsent() {
        long start = System.currentTimeMillis();
        log.info("Non-recurring consent expiration task has started!");
        this.consentJpaRepository.expireUsedNonRecurringConsents(EnumSet.of(ConsentStatus.RECEIVED, ConsentStatus.VALID));
        log.info("Non-recurring consent expiration task completed in {}ms!", (Object)(System.currentTimeMillis() - start));
    }

    @ConstructorProperties(value={"consentJpaRepository"})
    public NonRecurringConsentExpirationScheduleTask(ConsentJpaRepository consentJpaRepository) {
        this.consentJpaRepository = consentJpaRepository;
    }
}

