/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.scheduler;

import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.repository.ConsentJpaRepository;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ConsentScheduleTask {
    private static final Logger log = LoggerFactory.getLogger(ConsentScheduleTask.class);
    private final ConsentJpaRepository consentJpaRepository;

    @Scheduled(cron="${xs2a.cms.consent.cron.expression}")
    @Transactional
    public void checkConsentStatus() {
        log.info("Consent schedule task is run!");
        List<ConsentEntity> availableConsents = Optional.ofNullable(this.consentJpaRepository.findByConsentStatusIn(EnumSet.of(ConsentStatus.RECEIVED, ConsentStatus.VALID))).orElse(Collections.emptyList());
        this.consentJpaRepository.saveAll(this.updateConsent(availableConsents));
    }

    private List<ConsentEntity> updateConsent(List<ConsentEntity> availableConsents) {
        return availableConsents.stream().filter(ConsentEntity::isExpiredByDate).map(this::updateConsentParameters).collect(Collectors.toList());
    }

    private ConsentEntity updateConsentParameters(ConsentEntity consent) {
        consent.setConsentStatus(ConsentStatus.EXPIRED);
        consent.setExpireDate(LocalDate.now());
        return consent;
    }

    @ConstructorProperties(value={"consentJpaRepository"})
    public ConsentScheduleTask(ConsentJpaRepository consentJpaRepository) {
        this.consentJpaRepository = consentJpaRepository;
    }
}

