/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.scheduler;

import de.adorsys.psd2.consent.domain.consent.ConsentEntity;
import de.adorsys.psd2.consent.repository.ConsentJpaRepository;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class NonRecurringConsentExpirationScheduleTask {
    private static final Logger log = LoggerFactory.getLogger(NonRecurringConsentExpirationScheduleTask.class);
    private final ConsentJpaRepository consentJpaRepository;

    @Scheduled(cron="${used-non-recurring-consent-expiration.cron.expression}")
    @Transactional
    public void expireUsedNonRecurringConsent() {
        log.info("Non-recurring consent expiration task has started!");
        List consents = this.consentJpaRepository.findUsedNonRecurringConsents(EnumSet.of(ConsentStatus.RECEIVED, ConsentStatus.VALID), LocalDate.now()).stream().distinct().map(this::expireConsent).collect(Collectors.toList());
        this.consentJpaRepository.saveAll(consents);
    }

    private ConsentEntity expireConsent(ConsentEntity consent) {
        consent.setConsentStatus(ConsentStatus.EXPIRED);
        return consent;
    }

    @ConstructorProperties(value={"consentJpaRepository"})
    public NonRecurringConsentExpirationScheduleTask(ConsentJpaRepository consentJpaRepository) {
        this.consentJpaRepository = consentJpaRepository;
    }
}

