/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.scheduler;

import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.repository.AisConsentJpaRepository;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class NonRecurringConsentExpirationScheduleTask {
    private static final Logger log = LoggerFactory.getLogger(NonRecurringConsentExpirationScheduleTask.class);
    private final AisConsentJpaRepository aisConsentJpaRepository;

    @Scheduled(cron="${used-non-recurring-consent-expiration.cron.expression}")
    @Transactional
    public void expireUsedNonRecurringConsent() {
        log.info("Non-recurring consent expiration task has started!");
        List consents = this.aisConsentJpaRepository.findUsedNonRecurringConsents(EnumSet.of(ConsentStatus.RECEIVED, ConsentStatus.VALID), LocalDate.now()).stream().distinct().map(this::expireConsent).collect(Collectors.toList());
        this.aisConsentJpaRepository.saveAll(consents);
    }

    private AisConsent expireConsent(AisConsent consent) {
        consent.setConsentStatus(ConsentStatus.EXPIRED);
        return consent;
    }

    @ConstructorProperties(value={"aisConsentJpaRepository"})
    public NonRecurringConsentExpirationScheduleTask(AisConsentJpaRepository aisConsentJpaRepository) {
        this.aisConsentJpaRepository = aisConsentJpaRepository;
    }
}

