/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.scheduler;

import de.adorsys.psd2.consent.repository.PisCommonPaymentDataRepository;
import de.adorsys.psd2.consent.service.PisCommonPaymentConfirmationExpirationService;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class NotConfirmedPaymentExpirationScheduleTask {
    private static final Logger log = LoggerFactory.getLogger(NotConfirmedPaymentExpirationScheduleTask.class);
    private final PisCommonPaymentConfirmationExpirationService pisCommonPaymentConfirmationExpirationService;
    private final PisCommonPaymentDataRepository paymentDataRepository;

    @Scheduled(cron="${not-confirmed-payment-expiration.cron.expression}")
    @Transactional
    public void obsoleteNotConfirmedPaymentIfExpired() {
        log.info("Not confirmed payment expiration schedule task is run!");
        List expiredNotConfirmedPaymentDatas = this.paymentDataRepository.findByTransactionStatusIn(EnumSet.of(TransactionStatus.RCVD)).stream().filter(arg_0 -> ((PisCommonPaymentConfirmationExpirationService)this.pisCommonPaymentConfirmationExpirationService).isPaymentDataOnConfirmationExpired(arg_0)).collect(Collectors.toList());
        if (!expiredNotConfirmedPaymentDatas.isEmpty()) {
            this.pisCommonPaymentConfirmationExpirationService.updatePaymentDataListOnConfirmationExpiration(expiredNotConfirmedPaymentDatas);
        }
    }

    @ConstructorProperties(value={"pisCommonPaymentConfirmationExpirationService", "paymentDataRepository"})
    public NotConfirmedPaymentExpirationScheduleTask(PisCommonPaymentConfirmationExpirationService pisCommonPaymentConfirmationExpirationService, PisCommonPaymentDataRepository paymentDataRepository) {
        this.pisCommonPaymentConfirmationExpirationService = pisCommonPaymentConfirmationExpirationService;
        this.paymentDataRepository = paymentDataRepository;
    }
}

